/*
 * mlist.h -- multiple list
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: mlist.h,v 1.2 1998-03-25 08:43:48+09 satoshi Exp $

#ifndef __MLIST_H__
#define __MLIST_H__

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <list.h>

class Selector;

/*
 * MList Widget
 */
class MList {
private:
  Display* d;
  Selector* sel;
  Widget parent;
  static const char* className;
  const char* name;
  Widget paned;
  Widget* titlePaned;
  Widget* titleW;
  Widget* listW;
  Widget buttonBox;
  Widget showButton, hideButton;
  Widget vscrollbar;
  bool need_scrollbar;
  GC gc;
#ifdef KANJI
  XFontSet fontset;
#endif
  XFontStruct* xfs;
  unsigned long foreground, background, highlightBackground;

  enum Justify { left, center, right };

  unsigned columns;
  unsigned rows;
  char** titles;
  const char** list;
  unsigned* longest;
  Justify* justify;
  int index;		// selected index number (-1:none)
  unsigned first;	// first item shown
  unsigned cur_file;	// ???
  unsigned shown_columns;	// number of columns shown

  int* width;
  double* proportion;
  Dimension rowSpacing;
  Dimension internalHeight;
  Dimension internalWidth;

//  struct {
//    Pixmap pixmap;
//    int width;
//    int height;
//  } folder;

public:
  MList(Selector* sel_, Widget parent_, const char* name_, unsigned columns_,
	const char** titles_);
  ~MList();
  void createTitleW(unsigned i);
  void createSHVPaned(void);
  void initialize(void);
  void change(unsigned rows_, const char** list_, const unsigned* longest_);
  void clear(void);
  void select(int x, int y, bool flag);
  void highlight(int n);

  void up(void);
  void down(void);
  void scroll_up(void);
  void scroll_down(void);
  void top(void);
  void bottom(void);

  void redraw(Widget widget, int x = 0, int y = 0,
	      int width = -1, int height = -1);
  void redraw(void) {
    unsigned i;
    for(i = 0; i < shown_columns; i++)
      redraw(listW[i]);
  }
//  bool readXpm(const char* xpmfile, Pixmap* pixmap, int* width, int* height);

private:
  void resize(void);

  friend void ResizeCB(Widget widget, MList* self, XConfigureEvent* event,
		       Boolean* /**/);
  friend void ResizeCB2(Widget widget, MList* self, XConfigureEvent* event,
			Boolean* /**/);
  friend void ExposeCB(Widget widget, MList* self, XEvent* event);
  friend void ScrollCB(Widget widget, MList* self, int position);
  friend void JumpCB(Widget widget, MList* self, float* percent_ptr);
  friend void ShowCB(Widget widget, MList* self, void* /**/);
  friend void HideCB(Widget widget, MList* self, void* /**/);

  friend void PlayListAC(Widget, XEvent*, String*, Cardinal*);
  friend void FileListAC(Widget, XEvent*, String*, Cardinal*);
};

#endif // __MLIST_H__
