/*
 * menubar.cc -- menu bar
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: menubar.cc,v 1.4 1998-04-08 14:50:29+09 satoshi Exp $

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xresource.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include "menubar.h"


MenuBar::MenuBar(Widget parent)
{
  menubar = XtVaCreateManagedWidget("menubar", boxWidgetClass, parent,
				    XtNorientation, XtEhorizontal,
				    XtNborderWidth, 0,
				    XtNshowGrip,    False,
				    NULL);
  title[0] =
    XtVaCreateManagedWidget("FileMenu", menuButtonWidgetClass, menubar, NULL);
  Widget menushell0 =
    XtVaCreatePopupShell("menu", simpleMenuWidgetClass, title[0], NULL);
  XtVaCreateManagedWidget("Open", smeBSBObjectClass, menushell0,
			  XtNsensitive, False,
			  NULL);
  XtVaCreateManagedWidget("line", smeLineObjectClass, menushell0, NULL);
  XtVaCreateManagedWidget("Quit", smeBSBObjectClass, menushell0, NULL);
  XtAddCallback(XtNameToWidget(menushell0, "Open"), XtNcallback,
		(XtCallbackProc)FileCB, (XtPointer)FileMenu_Open);
  XtAddCallback(XtNameToWidget(menushell0, "Quit"), XtNcallback,
		(XtCallbackProc)FileCB, (XtPointer)FileMenu_Quit);
}


MenuBar::~MenuBar()
{
}


/*
 *
 */
void FileCB(Widget /*w*/, int index)
{
  extern void QuitAC(Widget, XEvent*, String*, Cardinal*);
  switch(index) {
  case FileMenu_Quit:
    QuitAC(NULL, NULL, NULL, NULL);
    break;
  }
}

