/*
 * main.cc -- MIDI file selector
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: main.cc,v 1.3 1998-03-25 07:57:37+09 satoshi Exp $

#define getopt getopt__
#include <stdlib.h>
#undef getopt
#include <stdio.h>

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
#include "../getopt.h"
#endif

#include "xmidisel.h"

#define EPLAYMIDI "eplaymidi"	// server name

static const char* version = "(" VERSION ")";

static void print_version(void);
static void print_usage(void);

static const char* prgname;

/*
 * main routine
 */
int main(int argc, char* argv[])
{
  prgname = argv[0];
  const char* directory = NULL;
  struct option long_options[] = {
    {"help",     no_argument,       NULL, 'h'},
    {"version",  no_argument,       NULL, 'V'},
    // X toolkit
    {"display",	 required_argument, NULL, 'D'},
    {"geometry", required_argument, NULL, 'G'},
    {"iconic",	 no_argument,       NULL, 'I'},
    {"xrm",      required_argument, NULL, 'R'},
    {NULL,       no_argument,       NULL,  0 }
  };
  optind = 0;
  opterr = 1;
  int c;
  for(;;) {
    int option_index = 0;
    if((c = getopt_long_only(argc, argv, "hV",
			     long_options, &option_index)) == EOF)
      break;
    switch(c) {
    case 'h': // show help
      print_usage();
      exit(EXIT_SUCCESS);
      break;
    case 'V': // display version number
      print_version();
      fprintf(stderr, 
	      "This is free software with ABSOLUTELY NO WARRANTY.\n"
	      "For details please see the file COPYING.\n");
      exit(EXIT_SUCCESS);
      break;
    case 'D': // X server to use
    case 'G': // geometry
    case 'I': // iconic
    case 'R': // resource
      break;		// bypass X toolkit option
    case ':': // missing parameter
    case '?': // unknown option character
      print_usage();
      exit(EXIT_FAILURE);
      break;
    default:
      fprintf(stderr,
	      "getopt_long_only() returned character code %02x\n", c&0xff);
      break;
    }
  }
  if(optind == argc-1)
    directory = argv[optind];
  else {
    print_version();
    print_usage();
    exit(EXIT_FAILURE);
  }

  Server* server = new Server(EPLAYMIDI);
  Selector* sel = new Selector(directory, argc, argv, server);
  sel->main();

  return EXIT_SUCCESS;
}


/*
 * print version number
 */
static void print_version(void)
{
  fprintf(stderr,
	  "MIDI file selector %s Copyright (C) 1996-1998 S.Kuramochi\n",
	  version);
}


/*
 * print usage
 */
static void print_usage(void)
{
  fprintf(stderr,
	  "usage: %s [-options] [directory]\n"
	  "  -h, --help           show this help\n"
	  "  -V, --version        display version number\n"
	  "  -display display     X server to use\n"
	  "  -geometry geometry   initial size and location\n"
	  "  -iconic              start iconic\n"
	  "  -xrm resourcestring  additional resource specifications\n"
	  ,
	  prgname);
}
