/*
 * filelist.cc -- file list
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: filelist.cc,v 1.3 1998-03-25 08:39:31+09 satoshi Exp $

#include <stdio.h>
#include <unistd.h>
#include "xmidisel.h"
#include "filelist.h"

static void selectCB(int n);
static void sortCB(int n);


FileList::FileList(Selector* sel_, Widget parent_, const char* path_,
		   const char* name, PlayList* playlist_)
: sel(sel_), parent(parent_), playlist(playlist_), dir(path_),
  sort_by(sort_name), sort_order(true)
{
  fileinfo = dir.read();
  _sort();
  const char* titles[] = {"File", "Title", "Date", "Size"};
  listW = new MList(sel, parent, name, 4, titles);   // 4 ???
}


/*
 * intialization
 */
void FileList::initialize(void)
{
  listW->initialize();
  change();
  sel->setWMName(dir.getPath());
}


FileList::~FileList()
{
  delete listW;
}


/*
 * 
 */
void FileList::change(void)
{
  int size;
  if((size = fileinfo.size()) > 0) {
    const char** newlist = new const char*[size*4];
    list<FileInfo>::iterator it;
    int i;
    for(it = fileinfo.begin(), i = 0; it != fileinfo.end(); it++, i++) {
      newlist[0*size+i] = it->getName();
      newlist[1*size+i] = it->getTitle();
      newlist[2*size+i] = it->getDateStr();
      newlist[3*size+i] = it->getSizeStr();
    }
    listW->change(size, newlist, NULL);
  }
}


/*
 * 
 */
void FileList::select(int n)
{
  if(n < 0 || fileinfo.size() <= n)
    return;

  list<FileInfo>::iterator it;
  int i;
  for(it = fileinfo.begin(), i = 0; i < n; it++, i++);
  if(it->isdirectory()) {
    dir.down(it->getName());
//    delete &fileinfo;
    fileinfo = dir.read();
    _sort();
    change();
    sel->setWMName(dir.getPath());
  } else {
    playlist->insert(*it);
  }
}


/*
 * 
 */
void FileList::sort(sort_type s)
{
  if(sort_by != s) {
    sort_by = s;
    _sort();
  }
  change();
}


/*
 * 
 */
void FileList::_sort(void)
{
  switch(sort_by) {
  case sort_name:
    if(sort_order)
      fileinfo.sort(compare_name_a);
    else
      fileinfo.sort(compare_name_d);
    break;
  case sort_title:
    if(sort_order)
      fileinfo.sort(compare_title_a);
    else
      fileinfo.sort(compare_title_d);
    break;
  case sort_date:
    if(sort_order)
      fileinfo.sort(compare_date_a);
    else
      fileinfo.sort(compare_date_d);
    break;
  case sort_size:
    if(sort_order)
      fileinfo.sort(compare_size_a);
    else
      fileinfo.sort(compare_size_d);
    break;
  }
}


/*
 * 
 */
void FileList::sort(int s, bool order)
{
  if(sort_by != s || sort_order != order) {
    sort_by = s;
    sort_order = order;
    _sort();
    change();
  }
}


/*
 * 
 */
void FileList::updir()
{
}


/*
 * 
 */
static void selectCB(int n)
{
}


/*
 * 
 */
static void sortCB(int n)
{
}
