/*
 * dir.cc -- Directory
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: dir.cc,v 1.2 1998/03/14 10:55:24 satoshi Exp $

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include "dir.h"

Directory::Directory(const char* path_)
: path(strdup(path_))
{
}


Directory::~Directory()
{
  delete[] path;
}


list<FileInfo>& Directory::read(void)
{
  list<FileInfo>* l = new list<FileInfo>;
  back_insert_iterator<list<FileInfo> > it(*l);

  DIR* dirp;
  if((dirp = opendir(path)) == NULL) {
    fprintf(stderr, "cannot open directory `%s'.\n", path);
    return *l;
  }
  struct dirent* dir_ent;
  while((dir_ent = readdir(dirp)) != NULL) {
    if(!strcmp(".", dir_ent->d_name))
      continue;
    char* filename;
    if(!strcmp("/", path)) {
      filename = new char[1+dir_ent->d_reclen+1];
      sprintf(filename, "/%s", dir_ent->d_name);
    } else {
      filename = new char[strlen(path)+1+dir_ent->d_reclen+1];
      sprintf(filename, "%s/%s", path, dir_ent->d_name);
    }
    FileInfo* finfo = new FileInfo(filename);
    delete[] filename;
    if(finfo->isdirectory() || finfo->ismidifile())
      *it++ = *finfo;
    else
      delete finfo;
  }
  closedir(dirp);
  return *l;
}


void Directory::open(const char* path_)
{
  delete[] path;
  path = strdup(path_);
}


void Directory::up(void)
{
}


void Directory::down(const char* dir_)
{
  if(!strcmp("..", dir_)) {
    char* p = path;
    if((p = strrchr(path, '/')) != NULL) {
      if(p != path) {
	*p = '\0';
	char* newpath = strdup(path);
	delete[] path;
	path = newpath;
      } else {
	delete[] path;
	path = strdup("/");
      }
    }
  } else {
    if(!strcmp("/", path)) {
      delete[] path;
      char* path = new char[1+strlen(dir_)+1];
      sprintf(path, "/%s", dir_);
    } else {
      char* newpath = new char[strlen(path)+1+strlen(dir_)+1];
      sprintf(newpath, "%s/%s", path, dir_);
      delete[] path;
      path = newpath;
    }
  }

//  fprintf(stderr, "%s\n", path);
}


void Directory::setFilter()
{
}


void Directory::rescan()
{
}
