/* << krbs >>
 * krbs.c       ver. 1.00
 * 96/12/18
 * By Kenta Cho(cho@ueda.info.waseda.ac.jp)
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char entryname[16][256],en;
char optionstring[1024]={""};
int lf=0,vf=0;

usage()
{
  fprintf(stderr,"Usage:  krbs [-options ...]\n");
  fprintf(stderr,"\n");
  fprintf(stderr,"where options include:\n");
  fprintf(stderr,"    -link                   make rbs\n");
  fprintf(stderr,"    -vrbs                   run vrbs\n");
  fprintf(stderr,"    -help                   show this help\n");
  fprintf(stderr,"    otherwise               vrbs options\n");
}

parseoptions(int argc,char **argv)
{
  int r;
  for ( r=1 ; r<argc ; r++ ) {
    if ( strcmp(argv[r],"-link")==0  ) lf=1;
    else if ( strcmp(argv[r],"-vrbs")==0  ) vf=1;
    else if ( strcmp(argv[r],"-h")==0 || strcmp(argv[r],"-help")==0 ) {
      usage(); exit(1);
    }
    else {
      strcat(optionstring," ");
      strcat(optionstring,argv[r]);
    }
  }
}

psystem(char *com)
{
  FILE *fp;
  fprintf(stderr,com);
  fprintf(stderr,"\n");
  system(com);
}

readenrty()
{
  FILE *fp;
  char s[256];
  int i=0,rn[2]={0,0};
  if ( NULL==(fp=fopen("entry.rbs","rt")) ) {
    fprintf(stderr,"Can't find entry.rbs\n");
    exit(1);
  }
  while ( !feof(fp) ) {
    fgets(s,255,fp);
    if ( feof(fp) ) break;
    if ( s[0]=='\\' ) i=1;
    else {
      strcpy(entryname[i],s);
      entryname[i][strlen(entryname[i])-1]='\0';
      i+=2;
      rn[(i&1)]++;
    }
  }
  fclose(fp);
  if ( rn[0]<=0 || rn[0]>8 || rn[1]<=0 || rn[1]>8 || rn[0]!=rn[1] ) {
    fprintf(stderr,"Error in entry.rbs\n");
    exit(0);
  }
  en=i-1;
}

makerbsmain()
{
  FILE *fp;
  char ss[1024],ts[16],sts[256];
  int i;
  fp=fopen("rbsmain.kl1","wt");
  fputs(":- module main.\n",fp);
  fputs("main :- true |\n",fp);
  strcpy(sts,"");
  for ( i=0 ; i<en ; i++ ) {
    strcpy(ss,entryname[i]);
    strcat(ss,":robot(S");
    sprintf(ts,"%d",i+1);
    strcat(ss,ts);
    strcat(ss,")@lower_priority,");
    fputs(ss,fp);
    strcat(sts,"S");
    strcat(sts,ts);
    strcat(sts,",");
  }
  sts[strlen(sts)-1]='\0';
  fputs("random:rands(RS),",fp);
  strcpy(ss,"rbs:callrb(RS,[");
  strcat(ss,sts);
  strcat(ss,"],MS,[ack|LastAck],LastAck,0),");
  fputs(ss,fp);
  strcpy(ss,"new_vector(ST,");
  sprintf(ts,"%d",en);
  strcat(ss,ts);
  strcat(ss,"),");
  fputs(ss,fp);
  fputs("rbs:battlemaneger(MS,ST,[],TTY,notabort),",fp);
  fputs("tty:ttystream(TTY).",fp);
  fclose(fp);
}

compilerobot()
{
  int i,r;
  char ss[1024];
  for ( i=0 ; i<en ; i++ ) {
    for ( r=0 ; r<i ; r++ )
      if ( strcmp(entryname[r],entryname[i])==0 ) break;
    if ( r==i ) {
      strcpy(ss,"klic -c ");
      strcat(ss,entryname[i]);
      strcat(ss,".kl1");
      psystem(ss);
    }
  }
  psystem("klic -c rbsmain.kl1");
  strcpy(ss,"klic -o rbs rbsmain.o rbs.o math.o tty2.o random.o ");
  for ( i=0 ; i<en ; i++ ) {
    for ( r=0 ; r<i ; r++ )
      if ( strcmp(entryname[r],entryname[i])==0 ) break;
    if ( r==i ) {
      strcat(ss,entryname[i]);
      strcat(ss,".o ");
    }
  }
  psystem(ss);
}

run()
{
  int i;
  char ss[1024],ts[16];
  strcpy(ss,"rbs | vrbs -name ");
  sprintf(ts,"%d ",en);
  strcat(ss,ts);
  for ( i=0 ; i<en ; i++ ) {
    strcat(ss,entryname[i]);
    strcat(ss," ");
  }
  strcat(ss,optionstring);
  psystem(ss);
}

main(int argc,char **argv)
{
  parseoptions(argc,argv);
  readenrty();
  if ( !vf ) {
    makerbsmain();
    compilerobot();
  }
  if ( !lf ) run();
}
