/*
 * WTC.java -- WTC (Weighted Throw Count)
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: WTC.java,v 1.4 1999-03-06 23:36:55+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a WTC (Weighted Throw Count).
 *
 * @author Satoshi KURAMOCHI
 */
public class WTC {
  private int value;

  // interpe.h
  static final int SUPPLY_WTC_UNIT = 0x1000000;
  static final int THROW_WTC_UNIT = 0x1000;
  static final int UNIFY_WTC_UNIT = 0x10;

  static final int NODE_WTC_LIMIT = 0x10000000;
  static final int RETURN_WTC_UNIT = 0x08000000;

  static final int MIN_WTC = 2;		 /* one for wtc_request,
					    another for node existence */
  static final int READ_WTC_UNIT = 10;
  static final int ANSWER_WTC_UNIT = 10;


  /**
   * Constructs a WTC.
   *
   * @param  value  a value.
   */
  public WTC(int value) {
    this.value = value;
  }


  public synchronized boolean isZero() {
    return (value == 0);
  }


  public synchronized int get(int amount) {
    value -= amount;
    return amount;
  }


  public synchronized int getAll() {
    int value0 = value;
    value = 0;
    return value0;
  }


  public synchronized int add(int amount) {
    value += amount;
    return amount;
  }


  public synchronized String toString() {
    return "" + value;
  }
}
