/*
 * Var.java -- a variable
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Var.java,v 1.2 1999-03-06 23:36:47+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a variable.
 *
 * Variables without suspended goals are represented as
 * self-referencing variables.
 * Variables _with_ suspended goals are represented as
 * a two-word pointer loop,
 * the second word being the suspension record structure.
 *
 * @author Satoshi KURAMOCHI
 */
public class Var extends KL1Object {
  /** the reference */
  public KL1Object refers;


  /**
   * Constructs a variable
   */
  public Var() {
    refers = this;
  }


  /**
   * Constructs a variable.
   *
   * @param  refers  a reference.
   */
  public Var(KL1Object refers) {
    this.refers = refers;
  }


  public KL1Object gunify(KL1Object that) {
    return this;
  }


  public void unify(KL1Machine mach, KL1Object y) {
    if(mach.UNIFYDEBUG)
      mach.print("Var.unify with " + this.print() + "," + y.print());
    KL1Object x = this;
    if(x instanceof Var) {
      KL1Object temp = ((Var)x).refers;
      while(true) {
	if (x != temp){
	  if (temp instanceof Var) {
	    KL1Object temp1 = ((Var)temp).refers;
	    if (temp1 == x) {
	      while (y instanceof Var) {
		KL1Object ytemp = ((Var)y).refers;
		if (y == ytemp) {
		  /* Suspension records must be referenced through REF. */
		  /* Thus, doing "derefone(y) = temp;" here is buggy. */
		  ((Var)y).refers = x;
		  return;
		} else {
		  if (ytemp instanceof Var && ((Var)ytemp).refers == y) {
		    y = ytemp;
		    x =  temp;
		    if (x != y) {
		      // merge two hook chains
		      Susprec sx = (Susprec)x;
		      Susprec sy = (Susprec)y;
		      if(sx.ggobj != null) {
			GGObj.generator_unify(mach, sx, sy);
		      } else if(sy.ggobj != null) {
			GGObj.generator_unify(mach, sy, sx);
		      } else {
			/* Both x and y are not generator */
			/* None of two is generator, then merge ... */
			Hook second_of_x = sx.first_hook.next;
			// connect sx and topy
			sx.first_hook.next = sy.first_hook.next;
			sy.first_hook.next = second_of_x;
			((Var)sy.refers).refers = sx.refers;
		      }
		    }
		    return;
		  }
		}
		y = ytemp;
	      }
	      // x is hook variable and y points a real object
	      mach.resume_goals(temp, y);
	      return;
	    } else {
	      x = temp;
	      temp = temp1;
	      continue;
	    }
	  } else {
	    x = temp;
	  }
	} else {
	  // dereference y
	  while (y instanceof Var) {
	    temp = ((Var)y).refers;
	    if (temp == y || (temp instanceof Var && ((Var)temp).refers == y))
	      break;
	    y = temp;
	  }
	  ((Var)x).refers = y;		// this also handles x==y cases
	  return;
	}
	break;
      }
    }

    // x is bound
    x.unify(mach, y);
  }


  /*
    Unifier that does never call unification recursively.
    To realize this, we make goals not only for recursive unifications
    but also for unification with hooked variables, to avoid the
    unifier to be called recursively from generic objects.
  */
  public void shallow_unify(KL1Machine mach, KL1Object y) {
    if(mach.UNIFYDEBUG)
      mach.print("Var.unify with " + this.print() + "," + y.print());
    KL1Object x = this;
    if(x instanceof Var) {
      KL1Object temp = ((Var)x).refers;
      while(true) {
	if (x != temp){
	  if (temp instanceof Var) {
	    KL1Object temp1 = ((Var)temp).refers;
	    if (temp1 == x) {
	      while (y instanceof Var) {
		KL1Object ytemp = ((Var)y).refers;
		if (y == ytemp) {
		  /* Suspension records must be referenced through REF. */
		  /* Thus, doing "derefone(y) = temp;" here is buggy. */
		  ((Var)y).refers = x;
		  return;
		} else {
		  if (ytemp instanceof Var && ((Var)ytemp).refers == y) {
		    mach.enqueue_unify_goal(x, y);
		    return;
		  }
		}
		y = ytemp;
	      }
	      // x is hook variable and y points a real object
	      mach.enqueue_unify_goal(x, y);
	      return;
	    } else {
	      x = temp;
	      temp = temp1;
	      continue;
	    }
	  } else {
	    x = temp;
	  }
	} else {
	  // dereference y
	  while (y instanceof Var) {
	    temp = ((Var)y).refers;
	    if (temp == y || (temp instanceof Var && ((Var)temp).refers == y))
	      break;
	    y = temp;
	  }
	  ((Var)x).refers = y;		// this also handles x==y cases
	  return;
	}
	break;
      }
    }

    // x is bound
    x.unify(mach, y);
  }


/*
  public boolean equals(KL1Object that) {
    return true;	// ???
  }
*/


  public String toString() {
    return "_" + Integer.toHexString(hashCode());
  }


  public String print() {	// ???
    if(refers == this)
      return toString();
    else {
      if(refers instanceof Var && this == ((Var)refers).refers)
	return "susp" + toString();	// Susprec ???
      else
	return refers.print();
    }
  }
}
