/*
 * SymAtom.java -- a symbolic atom
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: SymAtom.java,v 1.3 1999-03-06 04:41:20+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a symbolic atom.
 *
 * @author Satoshi KURAMOCHI
 */
public class SymAtom extends KL1Object {
  /** the name of the symbolic atom */
  public String name;	// must be intern()'ed


  /**
   * Constructs a symbolic atom.
   *
   * @param  name  The name of the symbolic atom.
   *               It must be intern()'ed.
   * @see    java.lang.String#intern()
   */
  public SymAtom(String name) {
    this.name = name;
  }


  /**
   * Constructs a symbolic atom.
   *
   * @param  name  The name of the symbolic atom.
   */
  public SymAtom(GString name) {
    this.name = name.toString().intern();
  }


  public KL1Object deref() {
    return this;
  }


  public KL1Object gunify(KL1Object that) {
    if((that = that.deref()) instanceof SymAtom)
      return (name == ((SymAtom)that).name) ? GDObj.SUCCESS : GDObj.FAILURE;
    else
      return (that instanceof Var) ? that : GDObj.FAILURE;
  }


  public void unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.resume_goals(temp, this);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (!(that instanceof SymAtom) || this.name != ((SymAtom)that).name)
      mach.enqueue_unify_terms(this, that);

/*
    if(this.getClass() == that.getClass())
      return (this.name == ((SymAtom)that).name);
    else
      return that.unify(this);
*/
  }


  public void shallow_unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.enqueue_unify_goal(this, that);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (!(that instanceof SymAtom) || this.name != ((SymAtom)that).name)
      mach.enqueue_unify_goal(this, that);

/*
    if(this.getClass() == that.getClass())
      return (this.name == ((SymAtom)that).name);
    else
      return that.unify(this);
*/
  }


  public boolean equals(KL1Object that) {
    if(that instanceof SymAtom) {
      return (this.name == ((SymAtom)that).name);
    } else
      return false;
  }


  public String toString() {
    return name;
  }


  public String print() { return toString(); }


  /** Represents a null list: '[]'. */
  public final static SymAtom nil = new SymAtom("[]".intern());
  /** Represents a period atom. */
  public final static SymAtom period = new SymAtom(".".intern());


  /**
   * Checks whether the object is nil.
   *
   * @return  true if the object is nil; false otherwise.
   */
  public final boolean isnil() { return name == nil.name; }
}

