/*
 * Prioqrec.java -- priority queue record
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Prioqrec.java,v 1.2 1999-03-06 23:36:18+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a priority queue record.
 *
 * @author Satoshi KURAMOCHI
 */
class Prioqrec {
  Prioqrec next;
  int prio;			// signed, to use -1 as sentinel
  Goalrec q;


  /**
   * Constructs a priority queue record.
   */
  Prioqrec() {
    next = null;
    prio = 0;
    q = null;
  }


  /**
   * Constructs a priority queue record.
   *
   * @param  next  the next entry.
   * @param  prio  a priority.
   * @param  q     a goal record.
   */
  Prioqrec(Prioqrec next, int prio, Goalrec q) {
    this.next = next;
    this.prio = prio;
    this.q = q;
  }
}
