/*
 * Predinfo.java -- predicate information
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Predinfo.java,v 1.2 1999-03-06 23:36:09+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a predicate information.
 *
 * @author Satoshi KURAMOCHI
 */
public class Predinfo {
  /** the name of the predicate */
  public String name;
  /** the predicate */
  public Predicate predstruct;


  /**
   * Constructs a predicate information.
   *
   * @param  name  the name of the predicate.
   * @param  predstruct  the predicate.
   */
  public Predinfo(String name, Predicate predstruct) {
    this.name = name;
    this.predstruct = predstruct;
  }


  public String toString() {
    return name + predstruct;
  }
}
