/*
 * Predicate.java -- predicate
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Predicate.java,v 1.2 1999-03-06 23:35:59+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a predicate.
 *
 * @author Satoshi KURAMOCHI
 */
public class Predicate extends KL1Object {
  /** the module where the predicate defined. */
  public Module func;
  /** the predicate number */
  public int pred;
  /** the number of args */
  public int arity;


  /**
   * Constructs a predicate.
   *
   * @param  func  the module where the predicate defined.
   * @param  pred  the predicate number.
   * @param  arity the number of arguments.
   */
  public Predicate(Module func, int pred, int arity) {
    this.func = func;
    this.pred = pred;
    this.arity = arity;
  }


  public String toString() {
    return "{" + func + ", " + pred + ", " + arity + "}";
  }


  public boolean equals(Predicate that) {
    return (func == that.func && pred == that.pred && arity == that.arity);
  }
}
