/*
 * Module.java -- module
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Module.java,v 1.3 1999-03-06 23:35:35+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a module.
 *
 * @author Satoshi KURAMOCHI
 */
public abstract class Module {
  /** the information of the module. */
  public Modinfo info;
  /** the predicates' information of the module. */
  public Predinfo preds[];


  /**
   * Initializes the module.
   *
   * @param  mach
   */
  public void init(KL1Machine mach) {}


  /**
   * Executes goals.
   *
   * @param  mach
   * @param  qp        the goal queue.
   * @param  topppred  the top predicate in the goal queue.
   * @return the module whose predicate first appears in the goal queue.
   */
  public abstract Module exec(KL1Machine mach, Goalrec qp, Predicate toppred);


  /**
   * Returns the specified predicate.
   *
   * @param  predname  the name of the predicate.
   * @param  arity     the arity of the predicate.
   * @return a predicate if it is found; <code>null</code> otherwise.
   */
  public Predicate get_pred(String predname, int arity) {
    Predicate pred = null;
    for(int i = 0; i < preds.length; i++)
      if(preds[i].predstruct.arity == arity && preds[i].name.equals(predname))
	pred = preds[i].predstruct;
    return pred;
  }


  public String toString() {
    return info.name;
  }


  public String print(int pred) {
    return preds[pred].name;
  }


  /**
   * main method.
   *
   * @param  argv  arguments.
   */
  public final static void main(String argv[]) {
    (new Thread((new KL1Machine(argv)))).start();
  }
}

