/*
 * Modinfo.java -- module information
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Modinfo.java,v 1.2 1999-03-06 23:35:27+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a module information.
 *
 * @author Satoshi KURAMOCHI
 */
public class Modinfo {
  /** the name of the module */
  public String name;
  /** the predicate informations */
  public Predinfo preds[];


  /**
   * Constructs a module informatino.
   *
   * @param  name   the name of the module.
   * @param  preds  the predicate informations.
   */
  public Modinfo(String name, Predinfo preds[]) {
    this.name = name;
    if(preds != null) {
      this.preds = new Predinfo[preds.length];
      for(int i = 0; i < preds.length; i++)
	this.preds[i] = preds[i];
    } else
      this.preds = null;
  }
}
