/*
 * KL1Object.java -- base class of any KL1 data representation
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: KL1Object.java,v 1.3 1999-03-06 23:38:25+09 satoshi Exp $
 */

package kl1.lang;

/**
 * Class <code>KL1Object</code> is the root of the KL1 data representation
 * class hierarchy.
 *
 * @author Satoshi KURAMOCHI
 */
public abstract class KL1Object {
  /**
   * Checks whether this object and <code>that</code> are unifiable.
   *
   * @param   that   the object with which to compare.
   * @return  <ul>
   *          <li><code>GDObj.SUCCESS</code> if guard unification succeeds.
   *          <li><code>GDObj.FAILURE</code> if guard unification fails.
   *          <li>the variable if <code>that</code> has an undefined variable.
   *          </ul>
   * @see     kl1.lang.GDObj.SUCCESS
   * @see     kl1.lang.GDObj.FAILURE
   */
  public KL1Object gunify(KL1Object that) {
    System.out.println("general guard unify on " + this.getClass().getName()
		       + " not available.");
    return GDObj.FAILURE;
  }


  /**
   * Unifies this object and <code>that</code>.
   *
   * @param   mach  
   * @param   that  the object with which to unify.
   */
  public void unify(KL1Machine mach, KL1Object that) {
    mach.fatal("general unify on " + this.getClass().getName()
	       + " not available.");
  }


  /**
   * Unifies this object and <code>that</code> without recursive unification.
   *
   * @param   mach  
   * @param   that  the object with which to unify.
   */
  public void shallow_unify(KL1Machine mach, KL1Object that) {
    mach.fatal("general shallow unify on " + this.getClass().getName()
	       + " not available.");
  }


  public boolean equals(KL1Object that) {
    System.out.println("general equals on " + this.getClass().getName()
		       + " not available.");
    return false;
  }


  public String toString() {
    System.out.println("general toString on " + this.getClass().getName()
		       + " not available.");
    return null;
  }


  /**
   * Prints the information of the object.
   *
   * @return  a string representation of the object.
   */
  public String print() {
    System.out.println("general print on " + this.getClass().getName()
		       + " not available.");
    return null;
  }


  /**
   * Creates generic objects.
   *
   * @param   mach  
   * @param   argv  arguments.
   * @return  the object to be created.
   */
  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    mach.fatal("general new on objects not available.");
    return null;
  }


  /**
   * Calls generic method.
   *
   * @param   mach  
   * @param   method  the name of the method.
   * @param   argv  arguments.
   */
  public void generic(KL1Machine mach, String method, KL1Object argv[]) {
    mach.print("### method " + method + " issued to " + print() + " ###\\n");
    mach.fatal("Generic method issued to a non-object");
  }


  /**
   * Dereferences the object.
   * 
   * @return  the object to be dereferenced.
   */
  public KL1Object deref() {
    KL1Object t = this;
    while(t instanceof Var) {
      KL1Object temp = ((Var)t).refers;
      if(temp instanceof Var && t == ((Var)temp).refers)
	return t;
      else
	t = temp;
    }
    return t;
  }
}
