/*
 * KL1Machine.java -- environment
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: KL1Machine.java,v 1.3 1999-03-06 23:34:59+09 satoshi Exp $
 */

package kl1.lang;

import java.io.*;
import java.util.*;

/**
 * This class represents an environment.
 *
 * @author Satoshi KURAMOCHI
 */
public class KL1Machine implements Runnable {
  // compile switch
  final static boolean DIST = false;
  final static boolean UNIFYDEBUG = false;
  final static boolean DEBUGLIB = false;

  private final static String package_name = "kl1.lang.";

  // Global Variables
  /** copy of real_heaplimit or 0 */
  public int heaplimit = 1;
  /** queue for current priority */
  public Goalrec current_queue;
  /** spontaneous goals during reduction */
  Goalrec resumed_goals;
  /** current priority */
  public int current_prio = 0;	// 0 ???
  /** highest priority with ready goal */
  int top_prio;
  Prioqrec prioq = new Prioqrec(null, 0, null);
				// priority queue head
  final int real_heaplimit = 1;	// limit of normal heap use
  double maxactiveratio;
  int interrupt_off;
  Goalrec interrupt_qp;

  // parallel comm Imp.
  int my_node;
  int total_node;

  String command_argv[];

  int suspensions, resumes, copied_susp;
//Const struct predicate *postmortem_pred0;
//q postmortem_args0;
  /** suspension reasons */
  public Var reasons[] = new Var[MAXSUSPENSION];

  boolean higher_priority_goal = false;
  KL1Object suspension_reason;
  KL1Object rest_of_stream = null;

  // interpe.h
  private final boolean isMasterNode() { return my_node == 0; }
  private final boolean isShoenNode() { return my_node == total_node; }

  WTC shoen_wtc = new WTC(0);	// ???
  WTC node_wtc = new WTC(0);	// ???

  // for tracing
  private int cum_susps, cum_resumps;
  private boolean start_tracing = false;
  private int count_suspension = 0;
//private suspended_goal_rec suspended_goal_list = null;
  private final int SUSPTABLESIZE = 256;

/*
  // susp.h
  // Perpetual Suspension Detection
  struct suspended_goal_rec {
    struct goalrec *goal;
    struct suspended_goal_rec *next;
  };
*/

  // param.h
  static final int MAXSUSPENSION = 1024;
				/* how many suspension reasons can exist */
  static final int MAXSTDARGS = 64;
				/* maximum number of arguments handled by
				   tracer or suspension for priority value */
  static final int MAXGENERICARGS = 64;
  				/* maximum number of arguments for
				   generic methods*/
  static final int MAXKLICINT = 2147483647;
				/* maximum KLIC integer */
  static final int MINKLICINT = -2147483648;
				/* minimum KLIC integer */
  static final int HIGHESTPRIO	= MAXKLICINT;
				/* highest priority */
  static final int PRIOQRECBULK = 64;
				/* how many priority queue records to */
				/* allocate at a time */
  //
  boolean finished = false;
  private Goalrec initialGoal = null;

  private Stack decodeStack = new Stack();

  // built-in predicates
  public final Module_builtin module_builtin = new Module_builtin();
  public final Module_generic module_generic = new Module_generic();
  public final Module_integer_arithmetics module_iarith
    = new Module_integer_arithmetics();
  public final Module_unify_term_dcode module_uterms
    = new Module_unify_term_dcode();
  public final Module_floating_arithmetics module_farith =
    new Module_floating_arithmetics();


  /**
   * Constructs an environment.
   */
  public KL1Machine() {}


  /**
   * Constructs an environment.
   *
   * @param  argv  arguments.
   */
  public KL1Machine(String argv[]) {
    command_argv = argv;
  }


/*
  public KL1Machine(Module module, KL1Object args[]) {
    Predicate p = locate_predicate_in_module(module, pred, arity);
    initialGoal = new Goalrec(null, p, args);
  }*/


  /**
   * Constructs an environment with a specified goal.
   *
   * @param  module  the module where the predicate is defined.
   * @param  pred    the name of the predicate.
   * @param  arity   the arity of the predicate.
   * @param  args    the argument.
   */
  public KL1Machine(String module, String pred, int arity, KL1Object args[]) {
    Predicate p = locate_predicate_in_module(module, pred, arity);
    initialGoal = new Goalrec(null, p, args);
  }


  // kmain.c  klic_main()
  public void run() {
    total_node = 1;	// ???

    if(total_node == 0)
      total_node = 1;

    my_node = total_node;	// only shoen node ???

    // spawn children ???

    initiate_prioq();

    if (isMasterNode()) {	// master node
//    qp->pred = &predicate_main_xmain_0;
//    node_wtc = new WTC(WTC.SUPPLY_WTC_UNIT);
    } else if (isShoenNode()) {	// shoen node
//    add_signal_handler(SIGTERM, kill_tasks);
//    shoen_wtc = new WTC(-WTC.SUPPLY_WTC_UNIT);
/*    struct timeval tp;
      if(!gettimeofday(&tp, NULL)){
	netstat.start_sec = tp.tv_sec;
	netstat.start_usec= tp.tv_usec;
      }*/
    }

    if(initialGoal == null) {
      Module module_main = load_module("main");
      initialGoal = new Goalrec(null, new Predicate(module_main, 0, 0), null);
      // predicate number == 0 ???
    }
    Goalrec qp = initialGoal;

    if(DEBUGLIB) {
      cum_susps = 0;
      cum_resumps = 0;
      suspensions = 0;
      resumes = 0;
    }
    if(DEBUGLIB) {
      cum_susps += suspensions;
      suspensions = 0;
      cum_resumps += resumes;
      resumes = 0;
      current_prio = -1;	// ???
//    suspended_goal_list = null;
      if (start_tracing) {
//	initiate_trace();
/*	if(isMasterNode())
	  qp = trace_goal(qp, 1, 0);*/
	start_tracing = false;
      }
      initialize_suspension_count_table();
    }

//  if(isMasterNode())	// ???
      enqueue_goal(null, HIGHESTPRIO-1, qp);

    current_queue = get_top_priority_queue();
    resumed_goals = null;
//  init_dist_signal_setup();
    interrupt_off = -1;
//  postmortem_pred = 0;
//  postmortem_args = 0;

    heaplimit = 1;	// ???

    toploop();

/*  DetachIO();
    CloseIO();
    Close_net();*/

    System.out.println("KL1 thread finished");
  }


  /**
   * Loads a specified module.
   *
   * @param  name  the name of the module.
   * @return the loaded module.
   */
  public Module load_module(String name) {
    return load_module(name, false);
  }


  private Hashtable module_table = new Hashtable();

  /**
   * Loads a specified module.
   *
   * @param  name  the name of the module.
   * @param  quiet
   * @return the loaded module.
   */
  public Module load_module(String name, boolean quiet) {
    Module module = (Module)module_table.get(name);
    if(module != null)
      return module;
    Class loaded_class;
    int reason = 0 ;
    String s1 = "Module_" + name;
    String s2 = s1 + ".class";
    try {
/*    if(!quiet)
	System.err.println("Loading " + s2 + ".");*/
      try {
	// at first, try built-in module
	loaded_class = Class.forName(package_name + s1);
	module = (Module)(loaded_class.newInstance());
      }
      catch(ClassNotFoundException e) {}
      if(module == null) {
	// then try user module
	loaded_class = Class.forName(s1);
	module = (Module)(loaded_class.newInstance());
      }
    }
    catch(ClassNotFoundException e) { reason = 1; }
    catch(IllegalAccessException e) { reason = 2; }
    catch(InstantiationException e) { reason = 3; }
    catch(ExceptionInInitializerError e) { reason = 4; }
    if(!quiet) {
      switch(reason) {	// ???
      case 1:
	fatal(s2 + " not found.");
	break;
      case 2:
	fatal("illegal access");
	break;
      case 3:
	fatal("instantiation error");
	break;
      case 4:
	fatal("exception in initializer");
	break;
      }
    }
    if(module != null) {
      module_table.put(name, module);
      module.init(this);
    }
    return module;
  }


  private void toploop() {
    Goalrec qp = current_queue;
    Predicate toppred = qp.pred;
    Module func = toppred.func;
    while(!finished) {
//System.err.println(toppred);
      func = func.exec(this, qp, toppred);
      qp = current_queue;
      toppred = qp.pred;
    }
  }


  void topmost() {
/*  if (postmortem_pred == 0 || postmortem_args == 0) break;
    klic_fprintf(stderr, "Starting postmortem processing...\n");
    allocp = initiate_prioq(heapp+incrementsize/2); // dirty patch
    qp = (struct goalrec *) allocp;
    qp.pred = postmortem_pred;
    allocp += 2;
    if (isfunctor(postmortem_args)) {
      int arity = arityof(functor_of(postmortem_args));
      int k;
      for (k=0; k<arity; k++) {
	*allocp++ = arg(postmortem_args, k);
      }
    }
    heapp = allocp;
    */
    finished = true;
  }


  // sched.c
  private Prioqrec new_prioqrec() {
    Prioqrec temp;
    while ((temp = prioqrec_free) == null) {
      prioqrec_free = more_prioqrec();
    }
    prioqrec_free = temp.next;
    return temp;
  }


  private void free_prioqrec(Prioqrec pqr) {
    pqr.next = prioqrec_free;
    prioqrec_free = pqr;
  }


  private Prioqrec prioqrec_free = null;

  private Prioqrec more_prioqrec() {
    int k;
    Prioqrec bulk[] = new Prioqrec[PRIOQRECBULK];
    bulk[PRIOQRECBULK-1] = new Prioqrec(null, 0, null);
    for (k = PRIOQRECBULK-1; k != 0; k--) {
      bulk[k-1] = new Prioqrec(bulk[k], 0, null);
    }
    return bulk[0];
  }


  final Predicate queue_empty_pred = new Predicate(new queue_empty(), 0, 0);
  final Predicate topsucceed_pred = new Predicate(new topsucceed(), 0, 0);
//IntAtom t0[] = new IntAtom(0);
  Goalrec goal_queue_tail = new Goalrec(null, queue_empty_pred, null);	// ???
  private static Predicate wait_prio_preds[] = new Predicate[MAXSTDARGS+1];
  Predicate wait_penum_preds[]
    = new Predicate[MAXSTDARGS+1]; // for inter nodes

  private Prioqrec pq;
  private static final Prioqrec tail_sentinel = new Prioqrec(null, -1, null);


  private void reinitiate_prioq() {
    pq = new_prioqrec();
    /*
       The tail of the lowest priority level is top level succeed goal.
     */
    pq.next = tail_sentinel;
    pq.prio = 0;
    pq.q = new Goalrec(goal_queue_tail, topsucceed_pred, null);
    prioq.next = pq;
  }


  private void initiate_prioq() {
    Module wait_prio = new wait_prio_routine();
    Module wait_penum = new wait_penum_routine();
    // Prepare for creating goals that wait for priority value
    for (int k=0; k<=MAXSTDARGS; k++)
      wait_prio_preds[k] = new Predicate(wait_prio, k, k+3);
    // Prepare for creating goals that wait for node value
    for (int k=0; k<=MAXSTDARGS; k++)
      wait_penum_preds[k] = new Predicate(wait_penum, k, k+2);
    reinitiate_prioq();
  }


  public Goalrec enqueue_throw_goal(KL1Object penum, Goalrec gp, Goalrec qp) {
    // just ignore ???
    return enqueue_goal(qp, current_prio, gp);
  }


  /**
   * Enqueues a goal.
   */
  public Goalrec enqueue_goal(Goalrec qp, int prio, Goalrec gp) {
//System.out.println("*enqueue_goal()");
    if (prio<0) prio = 0;
    if (current_prio == prio) {
      gp.next = qp;
      qp = gp;
    } else {
      Prioqrec pq = prioq;
      while (pq.next.prio > prio) {
	pq = pq.next;
      }
      if (pq.next.prio == prio) {
	// there already are some active goals with the same priority
	pq = pq.next;
	gp.next = pq.q;
	pq.q = gp;
      } else {
	/* there are no active goals with the same priority */
	/* must allocate a new prioqrec entry */
	Prioqrec newpq;
	newpq = new_prioqrec();
	newpq.next = pq.next;
	pq.next = newpq;
	newpq.prio = prio;
	newpq.q = gp;
	gp.next = goal_queue_tail;
      }
      // interrupt for higher priority goal
      if (current_prio < prio){
	higher_priority_goal = true;
	heaplimit = 0;
      }
    }
    return qp;
  }


  private void priority_type_error(Goalrec gp) {
    fatal("Non-integer priority specified");
  }


  public Goalrec enqueue_after_waiting(Goalrec qp, KL1Object prio, Goalrec gp,
				       boolean is_relative) {
    while(true) {
      if (prio instanceof IntAtom) {
	int prio_ = ((IntAtom)prio).value;
	return enqueue_goal(qp, (is_relative ? current_prio-prio_ : prio_),
			    gp);
      }
      if (!(prio instanceof Var))
	priority_type_error(qp);
      KL1Object value = ((Var)prio).refers;
      if (value != prio
	  && (!(value instanceof Var) || ((Var)value).refers != prio)) {
	prio = value;
	continue;
      }
      break;
    }
    KL1Object args[] = new KL1Object[gp.pred.arity+(2+3)];
    int k;
    for (k=0; k!=gp.pred.arity; k++) {
      args[k] = gp.args[k];
    }
//  args[k] = makecons(gp.pred);	// cons ???
    args[k] = gp.pred;
    args[k+1] = prio;
    args[k+2] = new IntAtom(is_relative ? 1 : 0);
    Goalrec ng = new Goalrec(null, wait_prio_preds[gp.pred.arity], args);

    Goalrec rsmg = resumed_goals;
    if (rsmg == null) {
      rsmg = ng;
      ng.next = ng;
    } else {
      ng.next = rsmg.next;
      rsmg.next = ng;
    }
    resumed_goals = rsmg;
    heaplimit = 0;
    return qp;
  }


  Goalrec get_top_priority_queue() {
    Goalrec newqp = prioq.next.q;
    current_prio = prioq.next.prio;
    Prioqrec newprioq = prioq.next.next;
    free_prioqrec(prioq.next);
    prioq.next = newprioq;
    return newqp;
  }


  void put_priority_queue(Goalrec qp, int prio) {
    Prioqrec pq = prioq;

    while(pq.next.prio >= prio) {
      pq = pq.next;
    }
    if (pq.next.prio == prio) {
      /* there are some active goals with the same priority */
      pq = pq.next;
      qp.next = pq.q;
      pq.q = qp;
    } else {
      /* there are no goals with the same priority */
      Prioqrec newpq = new_prioqrec();
      newpq.next = pq.next;
      pq.next = newpq;
      newpq.prio = prio;
      newpq.q = qp;
    }
  }


  // intrpt.c
  Goalrec enqueue_resumed_goals(Goalrec qp) {
    Goalrec rsmg = resumed_goals;
    if (rsmg != null) {
      Goalrec newqp = rsmg.next;
      rsmg.next = qp;
      qp = newqp;
      resumed_goals = null;
      if (interrupt_off != 0) heaplimit = real_heaplimit;
    }

/*
    String s = "*enqueue_resumed_goals():  ";
    for(Goalrec g = qp; g != null; g = g.next)
      s += g.print() + "  ";
    System.out.println(s);
*/
    return qp;
  }


  /**
   *
   */
  public void klic_interrupt(Goalrec qp) {
    boolean retry;

//System.out.println("*klic_interrupt()");
    qp = enqueue_resumed_goals(qp);

    do {
      retry = false;

      // signal handling
      klic_signal_handler();
      // some goals may have been resumed by the signal handler
      qp = enqueue_resumed_goals(qp);

      // priority support
      if (higher_priority_goal) {
	higher_priority_goal = false;
	put_priority_queue(qp, current_prio);
	qp = get_top_priority_queue();
	if (interrupt_off != 0) heaplimit = real_heaplimit;
      }
    } while (retry);
    current_queue = qp;
  }


  // signal.c
  // Synchronized signal handler called between reductions
  private void klic_signal_handler() {
    // ???
    while(!decodeStack.empty()) {
//    System.out.println("decoding");
      KL1Object x[];
      x = (KL1Object[])decodeStack.pop();
      x[0].unify(this, x[1]);
    }
  }


  // susp.h
  final void makenewsusp(Var var, Susprec srec) {
    var.refers = srec;
    srec.refers = var;
    srec.first_hook.next = srec.first_hook;
  }


  final void addhook(Hook oldhook, Hook newhook) {
    newhook.next = oldhook.next;
    oldhook.next = newhook;
  }


  // faisus.c
  private final void do_fail(Goalrec goal) {
    fatal("Reduction Failure: " + goal.print());
  }


  public void suspend_goal(Goalrec goal, Var reason) {
//System.err.println("suspend_goal");
//new Exception("Stack trace").printStackTrace();

    boolean suspended = false;
    Susprec susp;
    goal.prio = current_prio;
    goal.next = null;
    if (reason.refers == reason) {
      // no goals suspended yet on this variable
      susp = new Susprec();
      Var newvar = new Var();
      makenewsusp(newvar, susp);
      susp.first_hook.u = goal;
      reason.refers = newvar;
      suspended = true;
    } else {
      // some goals already has suspended
      susp = (Susprec)reason.refers;  // for shm implementation
      Hook newhook;
      // generator object ?
      if (susp.ggobj == null) {
	// then allocate new hook
	newhook = new Hook();
	newhook.next = susp.first_hook.next;
	susp.first_hook.next = newhook;
	newhook.u = goal;
	suspended = true;
      } else {
	Susprec gsusp = susp;
	Var ref = (Var)gsusp.refers;
	GGObj gobj = gsusp.ggobj;
	KL1Object tmp = gobj.generate();
	if (tmp != GDObj.SUCCESS) {
	  if ( tmp == GDObj.FAILURE ) {
	    KL1Object retval = gobj.suspend(ref, goal);
	    if(retval != null) {	// ???
	      resume_same_prio(goal);
	    } else {
	      suspended = true;
	    }
	  } else {
	    ref.refers = tmp;
	    resume_same_prio(goal);
	  }
	} else {
	  /* This case, the instantiation by generator object must
	     postponed. Thus:
	     1. ``goal'' is hooked on new variable ``newvar''.
	     2. enqueue unification goal between ``newvar'' and ``ref'' */
	  susp = new Susprec();
	  Var newvar = new Var();
	  makenewsusp(newvar,susp);
	  KL1Object args[] = { reason, newvar };
	  Goalrec newgp =
	    new Goalrec(current_prio,
			module_uterms.predicate_unify__goal_2, args);
	  susp.first_hook.u = goal;
	  suspended = true;
	  resume_same_prio(newgp);
	}
      }
    }
    if (suspended)
      suspensions++;
  }


  public final void interrupt_goal(KL1Object[] args, Predicate pred,
				   int reasonp) {
    Goalrec goal = new Goalrec(null, pred, args);

//System.err.println("interrupt_goal: " + pred);
//System.out.println("*interrupt_goal()");

    if (reasonp == -1) {
      /* Interrupt by some external event, such as: */
      /*   - A higher priority goal got ready for execution */
      /*   - Garbage collection required */
      /* In such cases, the interrupted goal is pushed down to the queue. */
      Goalrec rsmg = resumed_goals;
      if (rsmg == null) {
	goal.next = goal;
      } else {
	goal.next = rsmg.next;
	rsmg.next = goal;
      }
      resumed_goals = goal;
//System.out.println("*interrupt_goal():  a higher priority goal got ready");
      return;
    } else if (reasonp == 0) {
      do_fail(goal);
    } else {
      // First, try dereference
      // Compiled out code won't dereference more than one level
      for (int rp = 0; rp < reasonp; rp++) {
	Var v = reasons[rp], iv = v, ov;
	do {
	  KL1Object tmp = v.refers;
	  if (!(tmp instanceof Var)) {
	    iv.refers = tmp;
	    resume_same_prio(goal);
	    return;
	  }
	  ov = v;
	  v = (Var)tmp;
	} while (v.refers != ov);
      }
      // OK, the goal should really be suspended
//System.out.println("*suspended");
      goal.prio = current_prio;
      goal.next = null;
      {
	boolean redo_request = false;
	do {
	  Var tmp;
	  KL1Object tmp1;
	  tmp = reasons[--reasonp];
	  while (true) {
	    tmp1 = tmp.refers;
	    if (!(tmp1 instanceof Var)) {
	      resume_same_prio(goal);
	      return;
	    }
	    if (((Var)tmp1).refers == tmp) break;
	    tmp = (Var)tmp1;
	  }

	  if (tmp == tmp1) {
	    // no goals suspended yet on this variable
	    Susprec susp = new Susprec();
	    Var newvar = new Var();
	    makenewsusp(newvar, susp);
	    susp.first_hook.u = goal;
	    tmp.refers = newvar;
	  } else {
	    // some goals already has suspended
	    Susprec susp = (Susprec)tmp1;
	    // generator object ?
	    if(susp.ggobj == null) {
	      if (susp.first_hook.next.u == goal) {
		/* If the second hook is for the same goal, do nothing.
		   This includes the case where there's only one hook,
		   because of the loop structure of the hook chain. */
	      } else {
		Hook newhook = new Hook();
		addhook(susp.first_hook, newhook);
		newhook.u = goal;
	      }
	    } else {
	      // generator object
	      Susprec gsusp = susp;
	      Var ref = (Var)gsusp.refers;
	      GGObj gobj = gsusp.ggobj;
	      KL1Object tmp2 = gobj.generate();

	      if(tmp2 == GDObj.FAILURE) {
		if(gobj.suspend(ref, goal) != GDObj.SUCCESS)
		  redo_request = true;
	      } else {
		redo_request = true;
		if(tmp2 != GDObj.SUCCESS) {
		  ref.refers = tmp2;
		}
	      }
	    }
	  }
	} while (reasonp > 0);
	if (redo_request) {
	  resume_same_prio(goal);
	} else {
	  suspensions++;
	}
      }
    }
  }


  public final boolean check_stack_for_alternatively(int reasonp) {
    while (reasonp > 0) {
      // suspension stack is not empty
      KL1Object tmp, tmp1;
      Var var = reasons[--reasonp];
      Susprec susp;
      tmp = var;
      if (tmp instanceof Var) {
	while (true) {
	  tmp1 = ((Var)tmp).refers;
	  if (tmp == tmp1)
	    return false;
	  if (!(tmp1 instanceof Var)) {
	    var.refers = tmp1;
	    return true;
	  }
	  if (tmp == ((Var)tmp1).refers) break;
	  tmp = tmp1;
	}
	susp = (Susprec)tmp1;
	// generator object ?
	if (susp.ggobj != null) {
	  Var ref = (Var)susp.refers;
	  tmp = susp.ggobj.generate();
	  if (tmp == GDObj.SUCCESS)
	    return false;
	  ref.refers = tmp;
	  var.refers = tmp;
	  return true;
	}
      } else {
	var.refers = tmp;
	return true;
      }
    }
    return false;
  }


  // recsusp.c
  private void initialize_suspension_count_table() {
    int i;
    for (i=0; i<SUSPTABLESIZE; ++i) {
//    suspension_count_table[i] = 0;
    }
  }


  // unify.c
  /**
   * Enqueues an unify goal.
   */
  public final void enqueue_unify_terms(KL1Object x, KL1Object y) {
    KL1Object args[] = { x, y };
    Goalrec gp =
      new Goalrec(current_prio, module_uterms.predicate_unify_2, args);
    resume_same_prio(gp);
  }


  final void enqueue_unify_goal(KL1Object x, KL1Object y) {
    KL1Object[] args = { x, y };
    Goalrec gp =
      new Goalrec(current_prio, module_uterms.predicate_unify__goal_2, args);
    resume_same_prio(gp);
  }


  // Resume a goal with the same priority as current
  final void resume_same_prio(Goalrec gp) {

//System.out.println("*resume_same_prio()");

    if (resumed_goals == null) {
      resumed_goals = gp;
      gp.next = gp;
    } else {
      gp.next = resumed_goals.next;
      resumed_goals.next = gp;
    }
    heaplimit = 0;
  }


  // resume the goals which has been hooked to variable `x'.
  // by the unification with `y'
  final void resume_goals(KL1Object x, KL1Object y) {
    /* Variable x with suspended goals is instantiated here */
    /* x points suspension record directly. */
    Susprec susprecord = (Susprec)x;

//System.out.println("*resume_goals()");

    if(susprecord.ggobj != null) {
      // generator_object
      Susprec gsusp = susprecord;
      GGObj gobj = gsusp.ggobj;
      KL1Object tempallocp;
      if(!gobj.active_unify(this, y)) {
	// failed
	KL1Object tmp = gobj.generate();
	if(tmp == null)
	  /* x is a reference to suspension record. thus
	     derefone is needed for enqueue */
	  enqueue_unify_goal(((Susprec)x).refers, y);
	else if(tmp == GDObj.FAILURE)
	  fatal("illegal situation in generator unification");
	else {
	  ((Var)gsusp.refers).refers =  tmp;
	  if(tmp instanceof Var && tmp == ((Var)tmp).refers) {
	    ((Var)tmp).refers = y;
	  } else {
	    tmp.unify(this, y);
	  }
	}
      }
    } else {
      Hook top = susprecord.first_hook.next;
      Hook loopp = top;
  
      ((Var)susprecord.refers).refers = y;
  
      do {
	KL1Object u = loopp.u;
	if (u != null) {
	  if (u instanceof GCObj) {
	    GCObj obj = (GCObj)u;
	    KL1Object tmpval = null;
	    KL1Object keepp = loopp.u;
	    loopp.u = null;
	    KL1Object result = obj.active_unify(this, y);
	    if(result == GDObj.FAILURE)
	      fatal("Unification failure on a consumer object");
	    else if(result == GDObj.SUCCESS) {
	      if(rest_of_stream == null) {
		loopp = loopp.next;
		continue;
	      }
	      tmpval = rest_of_stream;
	    } else
	      tmpval = result;
	    Susprec susp = new Susprec();
	    Var newvar = new Var();
	    makenewsusp(newvar, susp);
	    susp.first_hook.u = obj;
	    if (((Var)tmpval).refers == tmpval)
	      ((Var)tmpval).refers = newvar;
	    else
	      enqueue_unify_goal(tmpval, newvar);
	  } else {
	    Goalrec g = (Goalrec)loopp.u;
	    if (g.next == null) {
	      int gp = g.prio;
	      if (gp != current_prio) {
//System.err.println("resumed: " + g.pred);
		enqueue_goal(null, gp, g);
	      } else {
//System.err.println("resumed: " + g.pred);
		resume_same_prio(g);
	      }
	      resumes++;
	    }
	  }
	}
	loopp = loopp.next;
      } while (loopp != top);
    }
  }


  // print.c
  public final static void print(String s) {
    System.out.println(s);	// ???
  }


  public final static void printl(KL1Object x) {
    System.out.println(x.print());
  }


  // debug.c
  public final static void debug_print(String s) {
    System.err.print(s);
  }


  /**
   * Handles a fatal error.
   *
   * @param  s  a message to be printed.
   */
  public final void fatal(String s) {
    System.err.println("Fatal Error: " + s);
    new Exception("Stack trace").printStackTrace();	// debug
    finished = true;	// ???
//  longjmp(klic_topmost, 1);	// ???
  }


  // gunix.kl1
  public GObject fopen(GString path_, String mode) {
    String path = path_.toString();
    try {
      File file = new File(path);
      Object f;
      if(mode.equals("r"))
	f = new FileInputStream(file);
      else if(mode.equals("w"))
	f = new FileOutputStream(file);
      else if(mode.equals("a"))
	f = new FileOutputStream(file);
      else if(mode.equals("r+"))
	f = new FileInputStream(file);
      else
	return null;
      return new GObject(f);
    }
    catch(FileNotFoundException e) { return null; }
    catch(IOException e) { return null; }
  }


  // xio.c
  public void klic_putc(int c, PrintStream out) {
    out.write(c);	// ???
  }


  public int klic_getc(InputStream in) {
    int c = -1;
    try {
      c = in.read();	// ???
    } catch(IOException e) {}
    return c;
  }


  public int klic_fread(byte b[], InputStream in) {
    int n = -1;
    try {
      n = in.read(b);	// ???
    } catch(IOException e) {}
    return n;
  }


/*public int klic_fread(byte pt[], int size, int items, InputStream in) {
    return in.read(pt, 0, size*items);	// ???
  }*/


/*public void klic_fwrite(byte pt[], int size, int items, PrintStream out) {
    try {
      out.write(pt, 0, size*items);
    } catch(IOException e) {}
  }*/


  public int klic_fwrite(String s, PrintStream out) {
    out.print(s);
    return s.length();
  }


  public boolean feof(Object s) {
    if(s instanceof InputStream) {
      try {
	if(((InputStream)s).available() > 0)
	  return false;
	else
	  return true;	// ???
      }
      catch(EOFException e) { return true; }
      catch(IOException e) { return false; }
    } else
      return false;
  }


  // cmphsh.c
  public KL1Object builtin_compare_terms(KL1Object x, KL1Object y) {
    final IntAtom lt = new IntAtom(-1);
    final IntAtom eq = new IntAtom(0);
    final IntAtom gt = new IntAtom(1);

    while(true) {
      y = y.deref();
      if(y instanceof Var)
	return y;
      x = x.deref();
      if(x instanceof Var)
	return x;
      else if (x instanceof IntAtom) {
	if (!(y instanceof IntAtom)) return lt;
	if (((IntAtom)x).value < ((IntAtom)y).value) return lt;
	if (((IntAtom)x).value > ((IntAtom)y).value) return gt;
	return eq;
      } else if(x instanceof SymAtom) {
	if (y instanceof IntAtom) return gt;
	return new IntAtom(((SymAtom)x).name.compareTo(((SymAtom)y).name));// ???
      } else if(x instanceof Cons) {
	if (y instanceof IntAtom || y instanceof SymAtom) return gt;
	if (!(y instanceof Cons)) return lt;
	KL1Object tmp = builtin_compare_terms(((Cons)x).car, ((Cons)y).car);
	if (!(tmp instanceof IntAtom) || ((IntAtom)tmp).value != 0) return tmp;
	x = ((Cons)x).cdr;
	y = ((Cons)y).cdr;
	continue;
      } else if(x instanceof Functor) {
	if (!(y instanceof Functor)) return gt;
	if (!(x instanceof GDObj)) {	// ???
	  if (y instanceof GDObj) return lt;	// ???
	  int t = ((Functor)x).functor.compareTo(((Functor)y).functor);	// ???
	  if(t != 0) return new IntAtom(t);
	  int arity = ((Functor)x).args.length;
	  int k;
	  for (k = 0; k < arity-1; k++) {
	    KL1Object tmp =
	      builtin_compare_terms(((Functor)x).args[k], ((Functor)y).args[k]);
	    if (!(tmp instanceof IntAtom) || ((IntAtom)tmp).value != 0)
	      return tmp;
	  }
	  x = ((Functor)x).args[k];
	  y = ((Functor)y).args[k];
	  continue;
	} else {
	  if (!(y instanceof GDObj)) return gt;	// ???
	  int t = ((Functor)x).functor.compareTo(((Functor)y).functor);	// ???
	  if(t != 0) return new IntAtom(t);
	  return ((GDObj)x).compare((GDObj)y);	// ???
	}
      }
    }
  }


  // bb.c
  // built-in body predicates
  private static final int bblt_add = 0;	// binary
  private static final int bblt_sub = 1;
  private static final int bblt_mult = 2;
  private static final int bblt_div = 3;
  private static final int bblt_mod = 4;
  private static final int bblt_and = 5;
  private static final int bblt_or = 6;
  private static final int bblt_xor = 7;
  private static final int bblt_rshift = 8;
  private static final int bblt_lshift = 9;
  private static final int bblt_plus = 10;	// unary
  private static final int bblt_minus = 11;
  private static final int bblt_complement = 12;


  private KL1Object builtin_body_3(KL1Object x, KL1Object y, int body,
				   Predicate pred, String name) {
    while(true) {
//  deref_x:
      if (x instanceof IntAtom) {
//    x_ok:
//    deref_y:
	if (y instanceof IntAtom) {
//	ok:
	  int z = 0;
	  switch(body) {
	  case bblt_add:
	    z = ((IntAtom)x).value + ((IntAtom)y).value;
	    break;
          case bblt_sub:
	    z = ((IntAtom)x).value - ((IntAtom)y).value;
	    break;
          case bblt_mult:
	    z = ((IntAtom)x).value * ((IntAtom)y).value;
	    break;
          case bblt_div:
	    z = ((IntAtom)x).value / ((IntAtom)y).value;
	    break;
          case bblt_mod:
	    z = ((IntAtom)x).value % ((IntAtom)y).value;
	    break;
          case bblt_and:
	    z = ((IntAtom)x).value & ((IntAtom)y).value;
	    break;
          case bblt_or:
	    z = ((IntAtom)x).value | ((IntAtom)y).value;
	    break;
          case bblt_xor:
	    z = ((IntAtom)x).value ^ ((IntAtom)y).value;
	    break;
          case bblt_rshift:
	    z = ((IntAtom)x).value >> ((IntAtom)y).value;
	    break;
          case bblt_lshift:
	    z = ((IntAtom)x).value << ((IntAtom)y).value;
	    break;
	  }
	  return new IntAtom(z);
	} else if (y instanceof Var) {
	  KL1Object yy;
	  yy = ((Var)y).deref();
	  if (yy instanceof IntAtom) {
	    y = yy;
//	    goto ok;
	    continue;
	  } else if (yy instanceof Var) {
	    if (yy == y) {
	      return suspend_builtin_3(y, x, y, pred);
	    } else {
	      KL1Object yyy = ((Var)yy).deref();
	      if (yyy == y) {
		return suspend_builtin_3(y, x, y, pred);
	      } else {
		y = yy;
//		goto deref_y;
		continue;
	      }
	    }
	  }
	}
      } else if (x instanceof Var) {
	KL1Object xx;
	xx = ((Var)x).deref();
	if (xx instanceof IntAtom) {
	  x = xx;
//	  goto x_ok;
	  continue;
	} else if (xx instanceof Var) {
	  if (xx == x) {
	    return suspend_builtin_3(x, x, y, pred);
	  } else {
	    KL1Object xxx = ((Var)xx).deref();
	    if (xxx == x) {
	      return suspend_builtin_3(x, x, y, pred);
	    } else {
	      x = xx;
//	      goto deref_x;
	      continue;
	    }
	  }
	}
      }
      builtin_3_type_error(x, y, pred, name);
      break;		// never reached
    }
    return null;	// never reached
  }


  private KL1Object builtin_body_2(KL1Object x, int body, Predicate pred,
				   String name) {
    while(true) {
//  deref_x:
      if (x instanceof IntAtom) {
//    ok:
	int z = 0;
	switch(body) {
	case bblt_plus:
	  z = +((IntAtom)x).value;
	  break;
	case bblt_minus:
	  z = -((IntAtom)x).value;
	  break;
	case bblt_complement:
	  z = ~((IntAtom)x).value;
	  break;
	}
	return new IntAtom(z);
      } else if (x instanceof Var) {
	KL1Object xx = ((Var)x).refers;
	if (xx instanceof IntAtom) {
	  x = xx;
//  	  goto ok;
	  continue;
	} else if (xx instanceof IntAtom) {
	  if (xx == x) {
	    return suspend_builtin_2(x, pred);
	  } else {
	    KL1Object xxx = ((Var)xx).refers;
	    if (xxx == x) {
	      return suspend_builtin_2(x, pred);
	    } else {
	      x = xx;
//	      goto deref_x;
	      continue;
	    }
	  }
	}
      }
      builtin_2_type_error(x, pred, name);
      break;		// never reached
    }
    return null;	// never reached
  }


  private void enqueue_as_resumed(Goalrec goal) {
    Goalrec rsmg = resumed_goals;
    if (rsmg == null) {
      rsmg = goal;
      goal.next = goal;
    } else {
      goal.next = rsmg.next;
      rsmg.next = goal;
    }
    resumed_goals = rsmg;
    heaplimit = 0;
  }


  private KL1Object suspend_builtin_3(KL1Object v, KL1Object x, KL1Object y,
				      Predicate pred) {
    KL1Object z = new Var();
    KL1Object args[] = { x, y, z };
    Goalrec goal = new Goalrec(null, pred, args);
    enqueue_as_resumed(goal);
    return z;
  }


  private KL1Object suspend_builtin_2(KL1Object v, Predicate pred) {
    KL1Object z = new Var();
    KL1Object args[] = { v, z };
    Goalrec goal = new Goalrec(null, pred, args);
    enqueue_as_resumed(goal);
    return z;
  }


  private void builtin_3_type_error(KL1Object x, KL1Object y, Predicate pred,
				    String name) {
    fatal("Argument type error in builtin predicate: " + name);
  }

  private void builtin_2_type_error(KL1Object x, Predicate pred, String name) {
    fatal("Argument type error in builtin predicate: " + name);
  }


  public KL1Object add_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_add, module_iarith.predicate_add_3,
			  "add/3");
  }

  public KL1Object subtract_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_sub, module_iarith.predicate_subtract_3,
			  "subtract/3");
  }

  public KL1Object multiply_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_mult, module_iarith.predicate_multiply_3,
			  "multiply/3");
  }

  public KL1Object divide_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_div, module_iarith.predicate_divide_3,
			  "divide/3");
  }

  public KL1Object modulo_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_mod, module_iarith.predicate_modulo_3,
			  "modulo/3");
  }

  public KL1Object and_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_and, module_iarith.predicate_and_3,
			  "and/3");
  }

  public KL1Object or_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_or, module_iarith.predicate_or_3, "or/3");
  }

  public KL1Object exclusive_or_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_xor,
			  module_iarith.predicate_exclusive__or_3,
			  "exclusive_or/3");
  }

  public KL1Object shift_right_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_rshift,
			  module_iarith.predicate_shift__right_3,
			  "shift_right/3");
  }

  public KL1Object shift_left_3(KL1Object x, KL1Object y) {
    return builtin_body_3(x, y, bblt_lshift,
			  module_iarith.predicate_shift__left_3,
			  "shift_left/3");
  }

  public KL1Object plus_2(KL1Object x) {
    return builtin_body_2(x, bblt_plus, module_iarith.predicate_plus_2,
			  "plus/2");
  }

  public KL1Object minus_2(KL1Object x) {
    return builtin_body_2(x, bblt_minus, module_iarith.predicate_minus_2,
			  "minus/2");
  }

  public KL1Object complement_2(KL1Object x) {
    return builtin_body_2(x, bblt_complement,
			  module_iarith.predicate_complement_2,
			  "complement/2");
  }

/*public KL1Object fix_2(KL1Object x) {
  }*/


  // gcode.c
  Predicate locate_predicate_in_module(String mname, String pname,
				       int arity) {
    Module module = load_module(mname);
    if(module == null)
      return null;
    else
      return module.get_pred(pname, arity);
  }


  // sched.c
  private final class queue_empty extends Module {
    public final Predicate predicate_queue_empty_0;
    
    public queue_empty() {
      predicate_queue_empty_0 = new Predicate(this, 0, 0);
      preds = new Predinfo[1];
      preds[0] = new Predinfo("queue_empty", predicate_queue_empty_0);
      info = new Modinfo("queue_empty", preds);
    }

    public Module exec(KL1Machine mach, Goalrec qp, Predicate toppred) {
//    System.out.println("queue_empty");

      qp = get_top_priority_queue();
      current_queue = qp;
      return qp.pred.func;
    }
  }


  private final class wait_prio_routine extends Module {
    public Module exec(KL1Machine mach, Goalrec qp, Predicate toppred) {
      int arity = toppred.pred;
      KL1Object prio = qp.args[arity+1];
      boolean is_relative = ((IntAtom)qp.args[arity+2]).value == 1;
      
      qp.pred = (Predicate)qp.args[arity];
//    qp.pred = (Predicate)consp(qp.args[arity]);	// cons ???
      qp = enqueue_after_waiting(qp.next, prio, qp, is_relative);
      current_queue = qp;
      return qp.pred.func;
    }
  }


  private final class wait_penum_routine extends Module {
    public Module exec(KL1Machine mach, Goalrec qp, Predicate toppred) {
/*
      int arity = toppred.pred;
      q penum = qp.args[arity+1];

      qp.pred = (struct predicate *)consp(qp.args[arity]);
      qp = enqueue_throw_goal(penum, qp, qp.next, allocp);
      heapp = allocp;
      current_queue = qp;
*/
      return qp.pred.func;
    }
  }


  // kmain.c
  private final class topsucceed extends Module {
    public final Predicate predicate_topsucceed_0;

    public topsucceed() {
      predicate_topsucceed_0 = new Predicate(this, 0, 0);
      preds = new Predinfo[1];
      preds[0] = new Predinfo("topsucceed", predicate_topsucceed_0);
      info = new Modinfo("topsucceed", preds);
    }

    public Module exec(KL1Machine mach, Goalrec qp, Predicate toppred) {
      System.err.println("topsucceed (" + (suspensions-resumes) + ")");

/* OLD
      if (suspensions == resumes) {
	topmost();	// ???
      }
      if(suspensions-resumes > 0) {	// ???
	fatal("" + (mach.suspensions-mach.resumes)
	      + " perpetually suspending goals found");
      }
      return null;*/

      while(true) {
	if(isShoenNode()) {	// if shoen node
/*	  if(shoen_wtc > 0) { 
	    ioeprintf("illegal wtc in shoen node\n");
	    fatal("illegal WTC");
	  } else*/ if(shoen_wtc.isZero()){
/*	    struct timeval tp;
	    if(!gettimeofday(&tp, NULL)){
	      iosprintf("Response time is %d msec\n",
		        (tp.tv_sec - netstat.start_sec)*1000 +
		        (tp.tv_usec - netstat.start_usec)/1000);
	    }*/
//	    terminate_all_node();
/*	    CloseIO();
	    Close_net();*/

	    System.err.println("topmost");
	    topmost();		// ???
	    return null;	// ???

//	    System.exit(0);
	  }
	} else {			// if normal node
	  if (suspensions == resumes /*&& !susp_msg_list*/) {
/* 	    if (node_wtc != 0)
	      send_return_wtc(node_wtc);*/
	  }
	}

	qp = new Goalrec(qp.next, topsucceed_pred, null);

	try {
//	  wait(20);	// ???
	  Thread.sleep(20);
	} catch(InterruptedException e) {
	}

	klic_interrupt(qp);
	qp = current_queue;

	if(qp.pred != topsucceed_pred)
	  break;
      }
      return current_queue.pred.func;
    }
  }


  // for multithread

  /**
   * Obtains a WTC.
   */
  public WTC get_wtc() {
    return new WTC(shoen_wtc.get(WTC.SUPPLY_WTC_UNIT));
  }


  /**
   * Sends an unification message.
   */
  public void send_unify(WTC wtc, KL1Object x, KL1Object y) {
//  enqueue_unify_goal(x, y);
//  x.unify(this, y);
    shoen_wtc.add(wtc.get(WTC.UNIFY_WTC_UNIT));
    decodeStack.push(new KL1Object[]{ x, y });

    // interrupt ???
    // stack -> queue ???
  }


  /**
   * Returns a WTC.
   */
  public void return_wtc(WTC wtc) {
    shoen_wtc.add(wtc.getAll());
  }
}


