/*
 * KL1Applet.java -- applet for KL1
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: KL1Applet.java,v 1.2 1999-03-06 23:33:25+09 satoshi Exp $
 */

package kl1.lang;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * This is a class for a KL1 applet.
 *
 * @author Satoshi KURAMOCHI
 */
public class KL1Applet extends Applet implements Runnable {
  private Thread thread = null;


  public KL1Applet() {
  }


  public void init() {
    System.out.println("[init]");
  }


  public void run() {
    WindowListener l = new WindowAdapter() {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    };

    Frame f = new Frame("TEST");
    f.addWindowListener(l); 

//  init();
//  start();
    f.add(this);
    f.setSize(300, 300);
    f.show();

    while(Thread.currentThread() == thread) {
      repaint();
      try {
	Thread.sleep(200);
      } catch(InterruptedException e) {}
    }
//  System.exit(0);
  }


  public void start() {
    System.out.println("[start]");
    if(thread == null) {
      thread = new Thread(this);
      thread.setPriority(Thread.NORM_PRIORITY+1);
      thread.start();
    }
  }


  public void stop() {
    System.out.println("[stop]");
    if(thread != null) {
//    thread.stop();	// deprecated
      thread = null;
    }
  }


  public void destroy() {
    System.out.println("[destroy]");
    System.exit(0);
  }


  public static void main(String args[]) {
    WindowListener l = new WindowAdapter() {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    };

    Frame f = new Frame("TEST");
    f.addWindowListener(l); 

    Applet a = new KL1Applet();
    a.init();
    a.start();
    f.add(a);
    f.setSize(300, 300);
    f.show();
  }
}
