/*
 * KL1Applet.java -- applet for KL1
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: KL1App.java,v 1.2 1999-03-06 23:33:14+09 satoshi Exp $
 */

package kl1.lang;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * This is a class for a KL1 applet.
 *
 * @author Satoshi KURAMOCHI
 */
public class KL1App extends Applet {
  protected Thread thread = null;
  protected Thread KL1Thread = null;
  protected String mainModule = null;
  protected static Applet applet = null;	// static ???

  protected KL1Machine mach = null;
  protected WTC wtc = null;
  protected Var stream = null;	// event stream

  private static final SymAtom atom_init = new SymAtom("init".intern());
  private static final SymAtom atom_start = new SymAtom("start".intern());
  private static final SymAtom atom_stop = new SymAtom("stop".intern());
  private static final SymAtom atom_destroy = new SymAtom("destroy".intern());


  public KL1App() {
  }


  public KL1App(String args0) {
    mainModule = args0;
  }


  // ???
  public static Applet getApplet() {
    return applet;
  }


  public static void main(String args[]) {
    if(args.length < 1) {
      System.err.println("KL1App: argument required.");
      System.exit(0);
    }
    // the remainder of arguments ???

    Frame f = new Frame("TEST");
    f.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });

    applet = new KL1App(args[0]);
    applet.init();
    applet.start();
    f.add(applet);
    f.setSize(300, 300);
    f.show();
  }


  public String[][] getParameterInfo() {
    String[][] info = {
      { "mainModule",	"String",	"a name of module starts with" },
    };
    return info;
  }


  public void init() {
    System.out.println("[init]");
    if(mainModule == null) {
      mainModule = getParameter("mainModule");
      if(mainModule.equals("")) {
	System.err.println("mainModule not specified.");
	System.exit(0);
      }
    }
    applet = this;

/*  Frame f = new Frame("TEST");
    f.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });

    f.add(applet);
    f.setSize(300, 300);
    f.show();*/

    // create KL1 thread
//    if(KL1Thread == null || !KL1Thread.isAlive()) {
      Cons stream1 = new Cons((stream = new Var()), atom_init);
      mach =
	new KL1Machine(mainModule, "applet", 1, new KL1Object[]{ stream1 });
      KL1Thread = new Thread(mach);
      KL1Thread.setPriority(Thread.NORM_PRIORITY-1);
      KL1Thread.start();
      wtc = mach.get_wtc();	// ???
//    }
  }


  public void start() {
    System.out.println("[start]");
    Var stream0 = stream;
    stream = new Var();
    mach.send_unify(wtc, stream0, new Cons(stream, atom_start));
  }


  public void stop() {
    System.out.println("[stop]");
    Var stream0 = stream;
    stream = new Var();
    mach.send_unify(wtc, stream0, new Cons(stream, atom_stop));
  }


  public void destroy() {
    System.out.println("[destroy]");
    mach.send_unify(wtc, stream, new Cons(SymAtom.nil, atom_destroy));
    mach.return_wtc(wtc);
    stream = null;

    System.exit(0);
  }
}
