/*
 * IntAtom.java -- an integer atom
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: IntAtom.java,v 1.2 1999-03-06 04:40:53+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents an integer atom.
 *
 * @author Satoshi KURAMOCHI
 */
public class IntAtom extends KL1Object {
  public int value;


  /**
   * Constructs an integer atom.
   *
   * @param  i  the value to be represented by the <code>IntAtom</code>.
   */
  public IntAtom(int i) {
    value = i;
  }


  public int valueof() {
    return value;
  }


  public KL1Object deref() {
    return this;
  }


  public KL1Object gunify(KL1Object that) {
    if((that = that.deref()) instanceof IntAtom)
      return (value == ((IntAtom)that).value) ? GDObj.SUCCESS : GDObj.FAILURE;
    else
      return (that instanceof Var) ? that : GDObj.FAILURE;
  }


  public void unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.resume_goals(temp, this);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (!(that instanceof IntAtom) || this.value != ((IntAtom)that).value)
      mach.enqueue_unify_terms(this, that);

/*  if(!(that instanceof IntAtom))
      return that.unify(this);
    return(this.value == ((IntAtom)that).value);*/
  }


  public void shallow_unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.enqueue_unify_goal(this, that);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (!(that instanceof IntAtom) || this.value != ((IntAtom)that).value)
      mach.enqueue_unify_goal(this, that);

/*  if(!(that instanceof IntAtom))
      return that.unify(this);
    return(this.value == ((IntAtom)that).value);*/
  }


  public boolean equals(KL1Object that) {
    if(that instanceof IntAtom)
      return(this.value == ((IntAtom)that).value);
    else
      return false;
  }


  public String toString() {
    return "" + value;
  }


  public String print() {
    return toString();
  }
}
