/*
 * Goalrec.java -- goal record
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Goalrec.java,v 1.2 1999-03-06 23:32:46+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a goal record.
 *
 * @author Satoshi KURAMOCHI
 */
public class Goalrec extends KL1Object {
  /** pointer to next goal */
  public Goalrec next;
  /** priority (while suspending) */		// ???
  public int prio;
  /** predicate descriptor of the goal */
  public Predicate pred;
  /** arguments */
  public KL1Object args[];


  /**
   * Constructs a goal record.
   *
   * @param  next  the pointer to the next goal.
   * @param  pred  the predicate descriptor of the goal.
   * @param  args  arguments.
   */
  public Goalrec(Goalrec next, Predicate pred, KL1Object args[]) {
    this.next = next;
    this.prio = 0;
    this.pred = pred;
    if(args != null) {
      this.args = new KL1Object[args.length];
      for(int i = 0; i < args.length; i++)
	this.args[i] = args[i];
    } else
      this.args = null;
  }


  /**
   * Constructs a goal record.
   *
   * @param  prio  the priority of the goal.
   * @param  pred  the predicate descriptor of the goal.
   * @param  args  arguments.
   */
  public Goalrec(int prio, Predicate pred, KL1Object args[]) {
    this.next = null;
    this.prio = prio;
    this.pred = pred;
    if(args != null) {
      this.args = new KL1Object[args.length];
      for(int i = 0; i < args.length; i++)
	this.args[i] = args[i];
    } else
      this.args = null;
  }


  public String toString() {
    return("{" + ((next != null) ? "next" : "null") + ", " + pred + ", " +
	   ((args != null) ? "args[" + args.length + "]" : "null") + "}");
  }


  public String print() {	// ???
    if(pred.func == null)
      return "pred.func == null";
    if(pred.func.preds == null)
      return "pred.func.preds == null";
    String s;
//  s = pred.func.toString() + ":" + pred.func.info.preds[pred.pred].name;
    s = pred.func.toString() + ":" + pred.func.print(pred.pred);
    s += "(";
    for(int i = 0; i < args.length; i++) {
      s += args[i].print();
      if(i < args.length-1)
	s += ",";
    }
    s += ")";
    return s;
  }
}

