/*
 * GTermarray.java -- term array
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GTermarray.java,v 1.2 1999-03-06 23:27:46+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a term array object.
 *
 * @author Satoshi KURAMOCHI
 */
public final class GTermarray extends GDObj {
  static { name = "termarray"; }

  /** KL1 terms */
  public KL1Object terms[];


  public KL1Object gunify(GDObj that) {
    if (!(that instanceof GTermarray))
      return GDObj.FAILURE;
    if (terms != ((GTermarray)that).terms)	// ???
      return GDObj.FAILURE;
    return GDObj.SUCCESS;
  }


  public void unify(KL1Machine mach, GDObj that) {
    if (!(that instanceof GTermarray))
      unify_fail(mach);
    if (terms != ((GTermarray)that).terms)	// ???
      unify_fail(mach);
    return;
  }


  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    return new GTermarray(argv);
  }


  /**
   * Constructs a term array object.
   *
   * @param  argv  KL1 terms.
   */
  public GTermarray(KL1Object argv[]) {
    terms = new KL1Object[argv.length];
    System.arraycopy(argv, 0, terms, 0, argv.length);
  }
}
