/*
 * GRandom.java -- random number generator
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GRandom.java,v 1.2 1999-03-06 23:31:59+09 satoshi Exp $
 */

package kl1.lang;

import java.util.Random;

/**
 * This class represents a random number generator.
 *
 * @author Satoshi KURAMOCHI
 */
public final class GRandom extends GGObj {
  static { name = "random"; }

  private int range;
//private int max;
  private Random random;


  public KL1Object generate() {
    int one_random;
    do {
      one_random = random.nextInt();
    } while (one_random < 0);

    Susprec s = new Susprec();
    Var var = new Var(s);
    Cons cons = new Cons(var, new IntAtom(one_random % range));

    s.refers = var;
    s.ggobj = this;
    return cons;
  }


  public String print() {
    return "RANDOM@" + Integer.toHexString(hashCode());
  }


  public boolean active_unify(KL1Machine mach, KL1Object that) {
    return false;
  }


  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    if (argv.length < 1 || argv.length > 2)
      mach.fatal("Wrong number of arguments (" + argv.length
		 + ") in creation of random number generator");

    int range;
    int seed;

    KL1Object argv0;
    if((argv0 = argv[0].deref()) instanceof Var)
      return GDObj.suspend_new(mach, (Var)argv0, GRandom.class, argv);
    if(!(argv0 instanceof IntAtom))
      mach.fatal("not integer");
    range = ((IntAtom)argv0).value;

    if (argv.length > 1) {
      KL1Object argv1;
      if((argv1 = argv[1].deref()) instanceof Var)
	return GDObj.suspend_new(mach, (Var)argv1, GRandom.class, argv);
      if(!(argv1 instanceof IntAtom))
	mach.fatal("not integer");
      seed = ((IntAtom)argv1).value;
    } else {
      seed = 0;
    }
    if (range < 1) {
      mach.fatal("Illegal first argument (" + range
		 + ") in creation of random number generator");
    }
    GRandom obj = new GRandom(range, seed);

    Susprec gsusp = new Susprec();
    Var newvar = new Var(gsusp);
    gsusp.refers = newvar;
    gsusp.ggobj = obj;
    return newvar;
  }


  /**
   * Constructs a random number generator.
   *
   * @param  range  A range of random numbers to be generated.
   *                It should be positive.
   * @param  seed   A seed for random number generation.
   */
  public GRandom(int range, int seed) {
    this.range = range;
//  this.max = ((((int)(~0)) << 1) >> 1)/range*range;	// ???
    random = new Random(seed);
  }
}
