/*
 * GObject.java -- object
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GObject.java,v 1.2 1999-03-06 23:31:50+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class wraps an object.
 *
 * @author Satoshi KURAMOCHI
 */
public final class GObject extends GDObj {
  static { name = "object"; }

  /** the wrapped object */
  public Object object;


  public KL1Object gunify(GDObj that) {
    if (!(that instanceof GObject) || object != ((GObject)that).object)
      return GDObj.FAILURE;
    return GDObj.SUCCESS;
  }


  public void unify(KL1Machine mach, GDObj that) {
    if (!(that instanceof GObject) || object != ((GObject)that).object)
      unify_fail(mach);
    return;
  }


  public static KL1Object _new(KL1Machine mach, Object object) {
    return new GObject(object);
  }


  /**
   * Constructs a wrapper.
   *
   * @param  object  an object reference.
   */
  public GObject(Object object) {
    this.object = object;
  }
}
