/*
 * GNotifier.java -- notifier
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GNotifier.java,v 1.2 1999-03-06 23:31:40+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a notifier.
 *
 * @author Satoshi KURAMOCHI
 */
public abstract class GNotifier extends GCObj {
  static { name = "notifier"; }


  /**
   * Called when the hooked variable is instantiated by active unification.
   * Override this method to notify instantiation of the hooked variable.
   *
   * @param  var  the value of hooked variable.
   */
  public void _notify(KL1Object var) {}


  // basic method definitions
  public KL1Object active_unify(KL1Machine mach, KL1Object that) {
    that = that.deref();
    if(that instanceof Var) {
      mach.fatal("illegal data for unify notifier");
    } else if(that instanceof Cons ||
	      that instanceof SymAtom || that instanceof IntAtom ||
	      that instanceof Functor ||
	      that instanceof GDObj) {
      _notify(that);
      mach.rest_of_stream = null;
      return GDObj.SUCCESS;
    } else
      mach.fatal("illegal data for unify notifier");
    return GDObj.FAILURE;
  }


  public String print() {
    return "$$NOTIFIER$";
  }


  // new method
  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {	// ???
    return GDObj.FAILURE;
  }


  public Var _new() {
    return make_hook_var(this);
  }


  /**
   * Constructs a notifier object.
   */
  public GNotifier() {}


  /**
   * Constructs a notifier object.
   */
  public GNotifier(Var var[]) {
    var[0] = make_hook_var(this);
  }
}
