/*
 * GModule.java -- module
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GModule.java,v 1.2 1999-03-06 23:31:09+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a module object.
 *
 * @author Satoshi KURAMOCHI
 */
public final class GModule extends GDObj {
  static { name = "module"; }

  private Module module;
  /** the name of the module */
  public String name_;

  private static final String functor_name_1 = "name_1".intern();
  private static final String functor_module_0 = "module_0".intern();
  private static final String functor_defined_2 = "defined_2".intern();


  // basic method definitions
  public KL1Object gunify(GDObj that) {
    if (!(that instanceof GModule) || !name_.equals(((GModule)that).name_))
      return GDObj.FAILURE;
    else
      return GDObj.SUCCESS;
  }


  public void unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.resume_goals(temp, this);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (!(that instanceof GModule) || !name_.equals(((GModule)that).name_))
      unify_fail(mach);
    else
      return;
  }


  // Generic method
  private final void body_name_1(KL1Machine mach, String method,
				 KL1Object argv[]) {
    argv[0].shallow_unify(mach, new SymAtom(name_));
  }


  public void generic(KL1Machine mach, String method, KL1Object argv[]) {
    if(method == functor_name_1)
      body_name_1(mach, method, argv);
    else
      mach.fatal("undefined method");
  }


  public String print() {
    return "<MODULE#"+ name_ + ">";
  }


  private KL1Object guard_module_0(KL1Object argv[]) {
    return GDObj.SUCCESS;
  }


  private KL1Object guard_defined_2(KL1Object argv[]) {
    KL1Object predname;
    if((predname = argv[0].deref()) instanceof Var)
      return predname;
    if(!(predname instanceof SymAtom))
      return GDObj.FAILURE;
    KL1Object arity;
    if((arity = argv[1]) instanceof Var)
      return arity;
    if(!(arity instanceof IntAtom) || ((IntAtom)arity).value < 0)
      return GDObj.FAILURE;
    if(module.get_pred(((SymAtom)predname).name, ((IntAtom)arity).value)
      /*GCode.locate_predicate_in_module(name_, ((SymAtom)predname).name,
					 ((IntAtom)arity).value)*/
      != null) {
      return GDObj.SUCCESS;
    } else {
      return GDObj.FAILURE;
    }
  }


  public KL1Object ggeneric(String method, KL1Object argv[]) {
    if(method == functor_module_0)
      return guard_module_0(argv);
    else if(method == functor_defined_2)
      return guard_defined_2(argv);
    else
      return GDObj.FAILURE;
  }


  // new_module function
  /*
   * The argument is only one and it's the name of the module
   */
  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    KL1Object atom;
    if((atom = argv[0].deref()) instanceof Var)
      return suspend_new(mach, (Var)atom, GModule.class, argv);
    if(!(atom instanceof SymAtom))
      error_in_new(mach, "Non-atom parameter");
    String name = ((SymAtom)atom).name;
    Module module;
    if((module = mach.load_module(name)) != null)
      return new GModule(module, name);
    else
      return atom;    // not found: return the name atom itself
  }


  /**
   * Constructs a module object.
   *
   * @param  module  the module.
   * @param  name_   the name of the module.
   */
  public GModule(Module module, String name_) {
    this.module = module;
    this.name_ = name_;
  }
}
