/*
 * GMerge.java -- merger
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GMerge.java,v 1.2 1999-03-06 23:30:58+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a merger.
 *
 * @author Satoshi KURAMOCHI
 */
public class GMerge extends GCObj {
  static { name = "merge"; }

  private int count;
  private KL1Object outstream;

  private static final String functor_element_2 = "element_2".intern();
  private static final String functor_vector_1 = "vector_1".intern();


  // basic method definitions
  public KL1Object active_unify(KL1Machine mach, KL1Object that) {
    while(true) {
      KL1Object argv[];
      if(that instanceof Cons) {
	Cons newout = new Cons(new Var(), ((Cons)that).car);
	outstream.shallow_unify(mach, newout);
	outstream = newout.cdr;
	that = ((Cons)that).cdr;
	continue;
      } else if(that instanceof SymAtom && ((SymAtom)that).isnil()) {
	if (--count == 0)
	  outstream.shallow_unify(mach, SymAtom.nil);
	mach.rest_of_stream = null;
	return GDObj.SUCCESS;
      } else if(that instanceof Functor) {
	break;
      } else if(that instanceof GVector) {
	argv = new KL1Object[1];
	((GVector)that).ggeneric(functor_vector_1, argv);
	int size = ((IntAtom)argv[0]).value;
	count += size - 1;
	if (count == 0) {
	  outstream.shallow_unify(mach, SymAtom.nil);
	} else {
	  argv = new KL1Object[2];
	  Var hook_var;
	  for (int i = 0; i < size; i++) {
	    argv[0] = new IntAtom(i);
	    ((GVector)that).ggeneric(functor_element_2, argv);
	    hook_var = new Var();
	    hook_var.refers = make_hook_var(this);
	    kl1_unify(mach, argv[1], hook_var);
	  }
	}
	mach.rest_of_stream = null;
	return GDObj.SUCCESS;
      } else if(that instanceof Var && that == ((Var)that).refers) {
	mach.rest_of_stream = that;
	return GDObj.SUCCESS;
      } else
	break;
    }
    mach.debug_print("### " + that.print() + " ###\n");
    mach.fatal("Illegal data unified with merger");
    return GDObj.FAILURE;
  }


  public String print() {
    return "$$MERGER$";
  }


  // new_merger function
  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    if(argv.length != 1)
      error_in_new(mach, "Arity mismatch");

    GMerge newmerger = new GMerge(1, argv[0]);
    Var var = make_hook_var(newmerger);
    return var;
  }


  /**
   * Constructs a merger.
   *
   * @param  count
   * @param  outstream 
   */
  public GMerge(int count, KL1Object outstream) {
    this.count = count;
    this.outstream = outstream;
  }
}
