/*
 * GJava.java -- Java object
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GJava.java,v 1.4 1999-03-06 23:30:39+09 satoshi Exp $
 */

package kl1.lang;

import java.lang.reflect.*;
import java.awt.event.*;

/**
 * This class represents a java object.
 *
 * @author Satoshi KURAMOCHI
 */
public class GJava extends GCObj {
  static { name = "java_object"; }

  private Object obj = null;
  /** saved input stream for suspension */
  private KL1Object stream0 = null;
  /** for static method/member access */
//private boolean isClass = false;

  private static final String string_false = "false".intern();
  private static final String string_true = "true".intern();
  private static final String string_void = "void".intern();
  private static final String functor_2B_2 = "_2B_2".intern();	// '+'
  private static final String functor_2D_2 = "_2D_2".intern();	// '-'
  private static final String functor_flush_1 = "flush_1".intern();
  private static final String functor_getEventStream_1 = "getEventStream_1".intern();
  private static final String functor_getMember_1 = "getMember_1".intern();
  private static final String functor_setMember_1 = "setMember_1".intern();
  private static final String functor_invokeMethod_2 = "invokeMethod_2".intern();
  private static final String functor_this_1 = "this_1".intern();
  private static final String functor_try_2 = "try_2".intern();


  // generic:new(java, var, class, args)
  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    if(argv.length < 1)
      error_in_new(mach, "Arity mismatch");

    KL1Object[] argv1 = new KL1Object[argv.length];
    int i;
    for(i = 0; i < argv.length; i++) {
      argv1[i] = argv[i].deref();
      if(argv1[i] instanceof Var)
	return suspend_new(mach, (Var)argv1[i], GJava.class, argv);
    }

    String class_name = null;
    if(argv1[0] instanceof GString || argv1[0] instanceof SymAtom)
      class_name = argv1[0].toString();
    else
      error_in_new(mach, "Illegal class name");

    GJava newobj = null;
    if(argv.length > 1) {
//    Class[] types = new Class[argv.length-1];
      Object[] argv2 = new Object[argv.length-1];
      for(i = 0; i < argv2.length; i++)
	argv2[i] = convertFromKL1(argv1[i+1]);
      newobj = new GJava(class_name, argv2);
    } else {
      newobj = new GJava(class_name);
    }

    Var var = make_hook_var(newobj);
    return var;
  }


  public KL1Object deref() {
    return this;
  }


  /**
   * Constructs a java object.
   *
   * @param  class_name  the class name of the object.
   * @param  argv        arguments.
   */
  public GJava(String class_name, Object[] argv) {
    Class class_ = null;
    try {
      class_ = Class.forName(class_name);
    } catch(ClassNotFoundException e) {
      System.out.println("ClassNotFoundException occurred");
    }

    Constructor ctor = null;
    Class[] types = new Class[argv.length];
    int i;
    for(i = 0; i < argv.length; i++) {
      types[i] = argv[i].getClass();
      if(types[i] == Integer.class /* ??? */)
	types[i] = Integer.TYPE;
    }
    try {
      ctor = class_.getConstructor(types);
    } catch(NoSuchMethodException e) {
      System.out.println("NoSuchMethodException occurred");
    } catch(SecurityException e) {
      System.out.println("SecurityException occurred");
    }
    try {
      obj = ctor.newInstance(argv);
    } catch(InstantiationException e) {
      System.out.println("InstantiationException occurred");
    } catch(IllegalAccessException e) {
      System.out.println("IllegalAccessException occurred");
    } catch(IllegalArgumentException e) {
      System.out.println("IllegalArgumentException occurred");
    } catch(InvocationTargetException e) {
      System.out.println("InvocationTargetException occurred");
    }
  }


  /**
   * Constructs a java object.
   *
   * @param  class_name  the class name of the object.
   */
  public GJava(String class_name) {
    Class class_ = null;
    try {
      class_ = Class.forName(class_name);
    } catch(ClassNotFoundException e) {
      System.out.println("ClassNotFoundException occurred");
      return;
    }

    try {
      obj = class_.newInstance();
    } catch(IllegalAccessException e) {
      System.out.println("IllegalAccessException occurred");
    } catch(InstantiationException e) {
      System.out.println("InstantiationException occurred");
    } catch(ExceptionInInitializerError e) {
      System.out.println("ExceptionInInitializerError occurred");
    }
  }


  // ???
  /**
   * Constructs a java object.
   *
   * @param  class_name  the class name of the object.
   */
  public GJava(String class_name, boolean isClass) {
    try {
      obj = Class.forName(class_name);
    } catch(ClassNotFoundException e) {
      System.out.println("ClassNotFoundException occurred");
    }
//  this.isClass = isClass;
  }


  // Object ???
  /**
   * Constructs a java object.
   *
   * @param  obj
   */
  public GJava(Object obj) {
    this.obj = obj;
  }


  /*
   * method(Args):Ret
   * method(Args)
   * method():Ret
   * member:Member
   * this(This)
   */
  public KL1Object active_unify(KL1Machine mach, KL1Object that) {
    if(obj == null)
      return GDObj.FAILURE;	// ???
    if(stream0 != null) {
      that = stream0;
      stream0 = null;
    }
    while(true) {
      that = that.deref();
      if(that instanceof Cons) {
	KL1Object message;
	message = ((Cons)that).car.deref();
	if(message instanceof Var) {
	  // unbound
	  mach.rest_of_stream = message;
  	  stream0 = that;
	  return GDObj.SUCCESS;
	} else if(message instanceof Functor) {
	  // method invocation
	  System.out.println("GJava " + (isClass() ? ((Class)obj).getName()
					 : obj.getClass().toString())
			     + " invoked with " + message.print());
	  Functor ftor = (Functor)message;
	  KL1Object retVar = null;
	  KL1Object exceptionVar = null;
	  boolean done = false;
	  if(ftor.functor == functor_this_1) {
	    // this(This)
//	    unify_value(mach, ftor.args[0], this);
	    unify_value(mach, this, ftor.args[0]);
	    done = true;
	  } else if(ftor.functor == functor_getEventStream_1) {
	    // getEventStream(ES)
	    Var es = new Var();
	    // rewrite ???
	    try {
	      ((java.awt.Button)obj).addActionListener(new MyActionListener(mach, es));
	    } catch(ClassCastException e) {
	      System.out.println("ClassCastException occurred");
	    }
	    unify_value(mach, ftor.args[0], es);
	    done = true;
	  } else if(ftor.functor == functor_try_2) {
	    // try(method(Args), Exception)
	    exceptionVar = ftor.args[1];
	    if(ftor.args[0] instanceof Functor)
	      ftor = (Functor)ftor.args[0];
	    else
	      mach.fatal("GJava: try(method, Excep) not implemented");	// ???
	    done = false;
	  }
	  if(ftor.functor == functor_2D_2) {
	    // method(Args)-Ret
	    retVar = ftor.args[1];
	    if(ftor.args[0] instanceof Functor)
	      ftor = (Functor)ftor.args[0];
	    else
	      mach.fatal("GJava: method-Ret not implemented");	// ???
	    done = false;
	  }
	  if(!done) {
	    Object ret = null;
	    Exception exception = null;
	    if(ftor.args.length == 1 && ftor.args[0] instanceof SymAtom &&
	       ((SymAtom)ftor.args[0]).name == string_void) {
	      // method(void)
	      try {
		ret = invoke(mach, ftor.normalize());
	      } catch(Exception e) {
		exception = e;
	      }
	    } else {
	      // method(Args)
	      KL1Object[] args = new KL1Object[ftor.args.length];
	      int i;
	      for(i = 0; i < args.length; i++) {
		if((args[i] = ftor.args[i].deref()) instanceof Var) {
		  mach.rest_of_stream = args[i];
		  stream0 = that;
		  return GDObj.SUCCESS;
		}
	      }
	      try {
		ret = invoke(mach, ftor.normalize(), args);
	      } catch(Exception e) {
		exception = e;
	      }
	    }
	    if(retVar != null && exception == null)
	      unify_value(mach, retVar, convertToKL1(ret));
	    if(exceptionVar != null) {
	      if(exception == null) {
		unify_value(mach, exceptionVar, SymAtom.nil);
	      } else {
		Functor f =
		  // an exception name must be normalized ???
		  new Functor(exception.getClass().getName() + "_1", 
			      new KL1Object[]{ new GJava((Object)exception) });
		unify_value(mach, exceptionVar, f);
	      }
	    }
	  }
	} else if(message instanceof SymAtom) {
	  // method()
	  System.out.println("GJava " + obj.getClass().getName()
			     + " invoked with " + message.print() + "()");
	  try {
	    invoke(mach, ((SymAtom)message).name);
	  } catch(Exception e) {
	    System.out.println("try(method()) not implemented");	// ???
	  }
	} else {
	  // error
	  break;
	}
	that = ((Cons)that).cdr;
	continue;
      } else if(that == SymAtom.nil) {
	// []
	// close method stream
	obj = null;	// release
	mach.rest_of_stream = null;
	stream0 = null;
	return GDObj.SUCCESS;
      } else if(that instanceof Var) {
	// unbound
	mach.rest_of_stream = that;
	stream0 = null;
	return GDObj.SUCCESS;
      }
      break;
    }
    mach.debug_print("Illegal message " + that.print() + "\n");
    mach.fatal("message error");
    return null;	// ???
  }


  // method invocation with argument(s)
  private Object invoke(KL1Machine mach, String message, KL1Object[] args) 
  throws Exception {
    Object[] args1 = new Object[args.length];
    int i;
    for(i = 0; i < args.length; i++) {
      args1[i] = convertFromKL1(args[i]);
      System.out.println("converted " + args[i].print() + " -> "
			 + args1[i].getClass().toString());
    }
    Class[] types = new Class[args.length];
    for(i = 0; i < args.length; i++) {
      types[i] = args1[i].getClass();
      if(types[i] == Integer.class /* ??? */)
	types[i] = Integer.TYPE;
    }
    Method[] methods = (isClass() ? (Class)obj : obj.getClass()).getMethods();
    for(i = 0; i < methods.length; i++) {
      Class[] paramTypes = null;
      if(((paramTypes = methods[i].getParameterTypes()).length
	  != args1.length)
	 || !methods[i].getName().equals(message))
	methods[i] = null;
    }	      
    boolean retry = true;
    Object ret = null;
    for(i = 0; retry && i < methods.length; i++) {
      try {
	if(methods[i] != null) {
	  ret = methods[i].invoke(isClass() ? null : obj, args1);
	  System.out.println("invoked successfully");
	  retry = false;
	}
      } catch(IllegalArgumentException e) {
      } catch(IllegalAccessException e) {
      } catch(InvocationTargetException e) {
      } /*catch(Exception e) {
	e.printStackTrace();
	mach.fatal("exception caught");
      }*/
    }
    if(retry)
      System.out.println("method not found");
    return ret;
  }


  // method invocation without argument
  private Object invoke(KL1Machine mach, String message) throws Exception {
    Method method = null;
    try {
      method =
	(isClass() ? (Class)obj : obj.getClass()).getMethod(message, null);
    } catch(NoSuchMethodException e) {
      System.out.println("NoSuchMethodException occurred");
    } catch(SecurityException e) {
      System.out.println("SecurityException occurred");
    }
    Object ret = null;
    try {
      ret = method.invoke(isClass() ? null : obj, null);
      System.out.println("invoked successfully");
    } catch(IllegalArgumentException e) {
    } catch(IllegalAccessException e) {
    } catch(InvocationTargetException e) {
    } /*catch(Exception e) {
      e.printStackTrace();
      mach.fatal("exception caught");
    }*/
    return ret;
  }


  /**
   * Convert a KL1 term to a Java object.
   *
   * @param   x   A KL1 object to be converted.
   *              This must be deref()'ed and instantiated.
   * @return  the object to be converted.
   */
  public static Object convertFromKL1(KL1Object x) {
    // x must be deref()'ed and instantiated
    if(x instanceof IntAtom) {
      return new Integer(((IntAtom)x).value);
    } else if(x instanceof SymAtom) {
      if(x == SymAtom.nil)		// []
	return null;
      else if(((SymAtom)x).name == string_true)	// true
	return Boolean.TRUE;
      else if(((SymAtom)x).name == string_false) // false
	return Boolean.FALSE;
      else
	return ((SymAtom)x).name;	// SymAtom
    } else if(x instanceof GJava) {	// GJava
      return ((GJava)x).obj;
    } else if(x instanceof GFloat) {	// GFloat
      return new Double(((GFloat)x).value);
    } else if(x instanceof GString) {	// GString
      return ((GString)x).toString();
    } else {
      System.out.println("Cannot convert KL1 term to Java object: "
			 + x.print());
      return null;	// ???
    }
  }


  /**
   * Convert a Java object to a KL1 object.
   *
   * @param   x   A Java object to be converted.
   * @return  the KL1 object to be converted.
   */
  public static KL1Object convertToKL1(Object x) {
    KL1Object ret = null;
    if(x == null) {			// void
      ret = new SymAtom(string_void);
    } else {
      if(x instanceof Integer) {	// int
	ret = new IntAtom(((Integer)x).intValue());
      } else if(x instanceof Long) {	// long
	ret = new IntAtom(((Long)x).intValue());
      } else if(x instanceof Short) {	// short
	ret = new IntAtom(((Short)x).intValue());
      } else if(x instanceof Character) {	// char
	ret = new IntAtom((int)((Character)x).charValue());	// ???
      } else if(x instanceof Boolean) {	// boolean
	ret = new SymAtom(((Boolean)x).booleanValue()
			  ? string_true : string_false);
      } else if(x instanceof Double) {	// double
	ret = new GFloat(((Double)x).doubleValue());
      } else if(x instanceof Float) {	// float
	ret = new GFloat(((Float)x).doubleValue());
      } else if(x instanceof String) {	// String
	ret = new GString((String)x);
      } else {				// generic
	ret = new GJava(x);
      }
      // others not implemented ???
    }
    System.out.println("converted " + x.getClass() + " -> " + ret.getClass());
    return ret;
  }


  public void unify(KL1Machine mach, KL1Object that) {	// ???
    if(that instanceof Var)
      that.unify(mach, this);
    else
      super.unify(mach, that);
  }


  // ???
  public Object get() {
    return obj;
  }


  private final boolean isClass() {
    return (obj instanceof Class);
  }


  public String print() {
    return ("$$GJava$"
	    + (isClass() ?
	       ((Class)obj).getName() : obj.getClass().toString()));
  }
}


final class MyActionListener implements ActionListener {
  private Var es;
  private KL1Machine mach;
  private WTC wtc;	// ???

  private static final String functor_actionPerformed_1 = "actionPerformed_1".intern();


  public MyActionListener(KL1Machine mach, Var es) {
    this.mach = mach;
    this.es = es;
    wtc = mach.get_wtc();	// ???
  }


  public void actionPerformed(ActionEvent e) {
    System.out.println("actionPerformed invoked");
    Var es0 = es;
    // ES0 = [actionPerformed(E)|ES]
    mach.send_unify(wtc, es0,
		    new Cons((es = new Var()),
			     new Functor(functor_actionPerformed_1,
					 new KL1Object[]{ new GJava((Object)e) })));
  }


  public void finalize() {
    mach.return_wtc(wtc);	// ???
  }
}
