/*
 * GGObj.java -- generic generator object
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GGObj.java,v 1.2 1999-03-06 04:42:37+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class is an abstract class for generic generator object.
 *
 * @author Satoshi KURAMOCHI
 */
public abstract class GGObj extends KL1Object {
  /** the name of the generic object */
  public static String name = "ggobj";


  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    return GDObj.FAILURE;
  }


  public KL1Object deref() {
    return this;
  }


  /**
   * Performs an active unification.
   *
   * @param   mach
   * @param   that  the object with which to unify.
   * @return  true if succeeds; false if fails.
   */
  public boolean active_unify(KL1Machine mach, KL1Object that) {
    return false;
  }


  /**
   * Generates a value.
   *
   * @return  the object to be generated;
   *          <code>GDObj.FAILURE</code> if fails.
   */
  public KL1Object generate() {
    return GDObj.FAILURE;
  }


  public KL1Object suspend(KL1Object reference, Goalrec goal) {
    return GDObj.FAILURE;
  }


//public int regist();
//public int deallocate();
//public KL1Object close();
//public KL1Object encode(int node);


  /*
     sx is a suspension structure
     and y is hook or generator
   */
  public static void generator_unify(KL1Machine mach,
				     Susprec gsx, Susprec sy) {
    /* At first, try unify method */
    if(!gsx.ggobj.active_unify(mach, sy.refers)) {
      /* unify of x is failed */
      if(sy.ggobj != null) {
	Susprec gsy = sy;
	if(!gsy.ggobj.active_unify(mach, gsx.refers)) {
	  /* x and y are both generator,
	     but both failed. */
	  GGObj gobjx = gsx.ggobj;
	  KL1Object tmpx = gobjx.generate();
	  if(tmpx == null) {
	    /* failed */
	    GGObj gobjy = gsy.ggobj;
	    KL1Object tmpy = gobjy.generate();
	    if(tmpy == null)
	      mach.enqueue_unify_goal(gsx.refers, sy.refers);
	    else if(tmpy == GDObj.FAILURE)
	      mach.fatal("illegal sictuation at the generator unification");
	    else {
	      ((Var)gsy.refers).refers = tmpy;
	      if(tmpy instanceof Var && tmpy == ((Var)tmpy).refers)
		((Var)tmpy).refers = gsx.refers;
	      else
		tmpy.unify(mach, gsx.refers);
	    }
	  } else if(tmpx == GDObj.FAILURE)
	    mach.fatal("illegal sictuation at the generator unification");
	  else {
	    gsx.refers = tmpx;
	    if(tmpx instanceof Var && tmpx == ((Var)tmpx).refers) {
	      ((Var)(sy.refers)).refers = tmpx;
	    } else {
	      tmpx.unify(mach, sy.refers);
	      return;
	    }
	  }
	}
      } else {
	/* The unify method for x is failed and
	   y is hook */
	GGObj gobjx = gsx.ggobj;
	KL1Object tmpx = gobjx.generate();
	if(tmpx == null)		/* GC request */
	  mach.enqueue_unify_goal(gsx.refers, sy.refers);
	else if(tmpx == GDObj.FAILURE)	 /* illegal */
	  mach.fatal("illegal situation at the generator unification");
	else {
	  ((Var)gsx.refers).refers = tmpx;
	  if(tmpx instanceof Var && tmpx == ((Var)tmpx).refers) {
	    ((Var)tmpx).refers = sy.refers;
	  } else {
	    tmpx.unify(mach, sy.refers);
	    return;
	  }
	}
      }
    }
  }
}
