/*
 * GFloat.java -- floating point
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GFloat.java,v 1.2 1999-03-06 04:40:31+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a floating point.
 *
 * @author Satoshi KURAMOCHI
 */
public final class GFloat extends GDObj {
  static { name = "float"; }

  protected double value;

  private static final String functor_print_1 = "print_1".intern();
  private static final String functor_int_1 = "int_1".intern();
  private static final String functor_sin_1 = "sin_1".intern();
  private static final String functor_cos_1 = "cos_1".intern();
  private static final String functor_tan_1 = "tan_1".intern();
  private static final String functor_asin_1 = "asin_1".intern();
  private static final String functor_acos_1 = "acos_1".intern();
  private static final String functor_atan_1 = "atan_1".intern();
  private static final String functor_sinh_1 = "sinh_1".intern();
  private static final String functor_cosh_1 = "cosh_1".intern();
  private static final String functor_tanh_1 = "tanh_1".intern();
//private static final String functor_asinh_1 = "asinh_1".intern();
//private static final String functor_acosh_1 = "acosh_1".intern();
//private static final String functor_atanh_1 = "atanh_1".intern();
  private static final String functor_exp_1 = "exp_1".intern();
  private static final String functor_log_1 = "log_1".intern();
  private static final String functor_sqrt_1 = "sqrt_1".intern();
  private static final String functor_ceil_1 = "ceil_1".intern();
  private static final String functor_floor_1 = "floor_1".intern();
//private static final String functor_round_1 = "round_1".intern();
  private static final String functor_plus_1 = "plus_1".intern();
  private static final String functor_minus_1 = "minus_1".intern();
  private static final String functor_add_2 = "add_2".intern();
  private static final String functor_subtract_2 = "subtract_2".intern();
  private static final String functor_multiply_2 = "multiply_2".intern();
  private static final String functor_divide_2 = "divide_2".intern();
  private static final String functor_pow_2 = "pow_2".intern();
  private static final String functor_less__than_1 = "less__than_1".intern();
  private static final String functor_not__greater__than_1 = "not__greater__than_1".intern();
  private static final String functor_not__less__than_1 = "not__less__than_1".intern();
  private static final String functor_greater__than_1 = "greater__than_1".intern();
  private static final String functor_equal_1 = "equal_1".intern();
  private static final String functor_not__equal_1 = "not__equal_1".intern();
  private static final String functor_float_0 = "float_0".intern();


  // basic method definitions
  public KL1Object gunify(GDObj that) {
    return ((that instanceof GFloat && this.value == ((GFloat)that).value)
	    ? GDObj.SUCCESS : GDObj.FAILURE);
  }


  public void unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.resume_goals(temp, this);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if(!(that instanceof GFloat) || this.value != ((GFloat)that).value)
      unify_fail(mach);
  }


  // Generic method
  private final void body_print_1(KL1Machine mach, String method,
				  KL1Object argv[]) {
/*
    q str;
    char buf[100];
    sprintf(buf, "%1.16g", value);
    if (STRCHR(buf, '.') == 0 &&
	strcmp(buf, "Infinity") && strcmp(buf, "-Infinity") &&
	strcmp(buf, "NaN")) {
      char *exponent = STRCHR(buf, 'e');
      if (exponent != 0) {
	char save[100];
	(void)strcpy(save, exponent);
	(void)strcpy(exponent, ".0");
	(void)strcpy(exponent+2, save);
      } else {
	(void)strcat(buf, ".0");
      }
    }
    str = convert_c_string_to_klic_string(buf,g_allocp);
    if(!(argv[0] instanceof Var) || ((Var)argv[0]).refers != argv[0])
      argv[0].shallow_unify(str);
    else
      ((Var)argv[0]).refers = str;
*/
  }


  private final void body_int_1(KL1Machine mach, String method,
				KL1Object argv[]) {
    KL1Object result = new IntAtom((int)value);
    unify_value(mach, argv[0], result);
  }


  private final double unary_plus(double x) { return x; }

  private final double unary_minus(double x) { return -x; }


  //  Generic Method Table
  public void generic(KL1Machine mach, String method, KL1Object argv[]) {
    if(method == functor_print_1)
      body_print_1(mach, method, argv);
    else if(method == functor_int_1)
      body_int_1(mach, method, argv);
    else {
      double result = 0.0;
      int result_index;
      GFloat newobj;
      switch(argv.length) {
      case 1:
	result_index = 0;

	if(method == functor_sin_1)
	  result = Math.sin(value);
	else if(method == functor_cos_1)
	  result = Math.cos(value);
	else if(method == functor_tan_1)
	  result = Math.tan(value);
	else if(method == functor_asin_1)
	  result = Math.asin(value);
	else if(method == functor_acos_1)
	  result = Math.acos(value);
	else if(method == functor_atan_1)
	  result = Math.atan(value);

	else if(method == functor_sinh_1)
	  mach.fatal("`sinh' not implemented");
//	  result = Math.sinh(value);
	else if(method == functor_cosh_1)
	  mach.fatal("`cosh' not implemented");
//	  result = Math.cosh(value);
	else if(method == functor_tanh_1)
	  mach.fatal("`tanh' not implemented");
//	  result = Math.tanh(value);

	/*
	else if(method == functor_asinh_1)
	  result = Math.asinh(value);
	else if(method == functor_acosh_1)
	  result = Math.acosh(value);
	else if(method == functor_atanh_1)
	  result = Math.atanh(value);
	  */
	else if(method == functor_exp_1)
	  result = Math.exp(value);
	else if(method == functor_log_1)
	  result = Math.log(value);
	else if(method == functor_sqrt_1)
	  result = Math.sqrt(value);
	else if(method == functor_ceil_1)
	  result = Math.ceil(value);
	else if(method == functor_floor_1)
	  result = Math.floor(value);
	/*
	else if(method == functor_round_1)
	  result = Math.rint(value);
	  */
	else if(method == functor_plus_1)
	  result = unary_plus(value);
	else if(method == functor_minus_1)
	  result = unary_minus(value);
	else
	  mach.fatal("undefined method");

	newobj = new GFloat(result);
	argv[result_index].shallow_unify(mach, newobj);
	return;

      case 2: {
	KL1Object another = argv[0];
	if((another = another.deref()) instanceof Var) {
	  suspend_generic_goal(mach, (Var)another, method, argv);
	  return;
	}
/*
	while (another instanceof Var) {
	  KL1Object temp0 = ((Var)another).refers;
	  if(temp0 instanceof Var && another == ((Var)temp0).refers) {
	    suspend_generic_goal(mach, (Var)another, method, argv);
	    return;
	  } else {
	    another = temp0;
	  }
	}
*/
	result_index = 1;
	if(!(another instanceof GFloat)) {
	  mach.debug_print("### \"" + another.print()
			   + "\" given to floating point method " + method
			   + " ###\n");
	  mach.fatal("Illegal argument in floating point object method.");
	}
	double another_value = ((GFloat)another).value;

	if(method == functor_add_2)
	  result = value + another_value;
	else if(method == functor_subtract_2)
	  result = value - another_value;
	else if(method == functor_multiply_2)
	  result = value * another_value;
	else if(method == functor_divide_2)
	  result = value / another_value;
	else if(method == functor_pow_2)
	  result = Math.pow(value, another_value);
	else
	  mach.fatal("undefined method");

	newobj = new GFloat(result);
	argv[result_index].shallow_unify(mach, newobj);
	return;
      }
      default:
	mach.fatal("undefined method");
	break;
      }
    }
  }


  // guard generic methods
  private boolean guard_less__than_1(KL1Object argv[]) {
    return (argv[0] instanceof GFloat
	    && this.value < ((GFloat)argv[0]).value);
  }


  private boolean guard_not__greater__than_1(KL1Object argv[]) {
    return (argv[0] instanceof GFloat
	    && this.value <= ((GFloat)argv[0]).value);
  }


  private boolean guard_not__less__than_1(KL1Object argv[]) {
    return (argv[0] instanceof GFloat
	    && this.value >= ((GFloat)argv[0]).value);
  }


  private boolean guard_greater__than_1(KL1Object argv[]) {
    return (argv[0] instanceof GFloat
	    && this.value > ((GFloat)argv[0]).value);
  }


  private boolean guard_equal_1(KL1Object argv[]) {
    return (argv[0] instanceof GFloat
	    && this.value == ((GFloat)argv[0]).value);
  }


  private boolean guard_not__equal_1(KL1Object argv[]) {
    return (argv[0] instanceof GFloat
	    && this.value != ((GFloat)argv[0]).value);
  }


  private boolean guard_float_0() { return true; }


  public KL1Object ggeneric(String method, KL1Object argv[]) {
    boolean ret;
    if(method == functor_less__than_1)
      ret = guard_less__than_1(argv);
    else if(method == functor_not__greater__than_1)
      ret = guard_not__greater__than_1(argv);
    else if(method == functor_not__less__than_1)
      ret = guard_not__less__than_1(argv);
    else if(method == functor_greater__than_1)
      ret = guard_greater__than_1(argv);
    else if(method == functor_equal_1)
      ret = guard_equal_1(argv);
    else if(method == functor_not__equal_1)
      ret = guard_not__equal_1(argv);
    else if(method == functor_float_0)
      ret = guard_float_0();
    else
      ret = false;
    return ret ? GDObj.SUCCESS : GDObj.FAILURE;
  }


  public String print() { return "" + value; }


  public IntAtom compare(GFloat that) {
    return new IntAtom((value > that.value)
		       ? 1 : (value < that.value) ? -1 : 0);
  }


  public IntAtom hash() { return new IntAtom((int)value); }


  /**
   * Constructs a float object.
   *
   * @param  value  the value to be represented by the <code>GFloat</code>.
   */
  public GFloat(double value) { this.value = value; }


//public GFloat(String value) {  }


  // new_float function
  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    KL1Object init = argv[0].deref();
    if(init instanceof Var)
      return suspend_new(mach, (Var)init, GFloat.class, argv);
    GFloat newobj = null;
    if (init instanceof IntAtom) {
      newobj = new GFloat((double)((IntAtom)init).value);
    }
    /*else if (init instanceof GString) {
      newobj = new GFloat(generic_string_body(init));
    } */
    else {
      mach.debug_print("### " + init.print() + "%k ###\n");
      mach.fatal("Illegal initial value for floating point objects");
    }
    return newobj;
  }
}
