/*
 * GDObj.java -- generic data object
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GDObj.java,v 1.3 1999-03-06 04:40:07+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class is an abstract class for generic data object.
 *
 * @author Satoshi KURAMOCHI
 */
public abstract class GDObj extends KL1Object {
  /** the name of the generic object */
  public static String name = "gdobj";


  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    return FAILURE;	// ???
  }


  public KL1Object gunify(KL1Object that) {
    return SUCCESS;
  }


  public void unify(KL1Machine mach, KL1Object that) {
    return;
  }


  public KL1Object deref() {
    return this;
  }


//public int regist() { return 1; }
//public int deallocate() { return 1; }
//public void/*KL1Object*/ close() { return; }
//public boolean/*KL1Object*/ encode(int node) { return false; }


  public void shallow_unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("GDObj.unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.enqueue_unify_goal(this, that);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (this != that)
      mach.enqueue_unify_goal(this, that);
  }


  public void generic(KL1Machine mach, String method, KL1Object argv[]) {
    return;
  }


  /**
   * Calls guard generic method.
   *
   * @param   method  the name of the method.
   * @param   argv  arguments.
   */
  public KL1Object ggeneric(String method, KL1Object args[]) {
    return GDObj.SUCCESS;
  }


  public IntAtom compare(GDObj that) {
/*  mach.debug_print("### %k compared with %k ###\n",
		     makefunctor(GD_SELF), makefunctor(GD_OTHER));
    mach.fatal("Comparision of objects of an inappropriate class made");*/
    return new IntAtom(1);	// ???
  }


  public IntAtom hash() {
    return new IntAtom(hashCode());
  }


  /** Represents a success */
  public final static KL1Object SUCCESS = GSUCCESS.getInstance();
  /** Represents a failure */
  public final static KL1Object FAILURE = GFAILURE.getInstance();


  protected static Var suspend_new(KL1Machine mach, Var reason,
				   Class class_, KL1Object argv[]) {
    Var newvar = new Var();
    Var var = new Var(newvar);
    GObject newobj = new GObject(class_);
    GTermarray term = new GTermarray(argv);
    KL1Object args[] = { newvar, newobj, term };
    Predicate pred = mach.module_generic.predicate_new_3;
    Goalrec goal = new Goalrec(null, pred, args);
    mach.suspend_goal(goal, reason);
    return var;
  }


  public static void suspend_generic(KL1Machine mach, Var var,
				     String method, KL1Object argv[]) {
    suspend_generic_goal(mach, var, var, method, argv);
  }


  public void suspend_generic_goal(KL1Machine mach, Var var,
				   String method, KL1Object argv[]) {
    suspend_generic_goal(mach, this, var, method, argv);
  }


  // obj: a data object or a variable to be instantiated to a data object
  public static void suspend_generic_goal(KL1Machine mach, KL1Object obj,
					  Var var, String method,
					  KL1Object argv[]) {
    Functor funct = new Functor(method, argv);
    Predicate pred = mach.module_generic.predicate_generic_2;
    Goalrec goal = new Goalrec(null, pred, new KL1Object[]{ funct, obj });
    mach.suspend_goal(goal, var);
  }


  // gd_macro.h
  protected static void error_in_new(KL1Machine mach, String errmesg) {
    mach.fatal(errmesg + "\n\t(in creation of data object of class \""
	       + name + "\")");
  }


  protected static void error_in_method(KL1Machine mach, String errmesg,
					String methodname) {
    mach.fatal(errmesg + "\n\t(in " + methodname +
	       " of data object of class \"" + name + "\")");
  }


  protected static void unify_fail(KL1Machine mach) {
    mach.fatal("Failure\n\t(in active unification of data object of class \""
	       + name + "\")");
  }


  protected static void unify_value(KL1Machine mach,
				    KL1Object x, KL1Object y) {
    if (!(x instanceof Var) || ((Var)x).refers != x)
      y.shallow_unify(mach, x);
    else
      ((Var)x).refers = y;
  }


  protected KL1Object set_intarg_within_range(KL1Machine mach,
					      String method,
					      KL1Object argv[],
					      int var[], int i,
					      int llim, int ulim) {
    KL1Object argv_i = argv[i];
    while (!(argv_i instanceof IntAtom)) {
      if (!(argv_i instanceof Var))
	error_in_method(mach, "Non-integer paramter", method);
      if((argv_i = argv_i.deref()) instanceof Var) {
	suspend_generic_goal(mach, (Var)argv_i, method, argv);
	return null;	// when null is returned, goal is suspended.
      }
    }
    var[0] = ((IntAtom)argv_i).value;
    if (llim > var[0] || var[0] >= ulim)
      error_in_method(mach, "out of range", method);
    return argv_i;
  }


  protected static KL1Object set_gintarg_within_range(int var[], KL1Object x,
						      int from, int to) {
    while (!(x instanceof IntAtom)) {
      if (!(x instanceof Var))
	return GDObj.FAILURE;
      if((x = x.deref()) instanceof Var)
	return x;
    }
    var[0] = ((IntAtom)x).value;
    if(from > var[0] || var[0] >= to)
      return GDObj.FAILURE;
    else
      return GDObj.SUCCESS;
  }
}


final class GSUCCESS extends KL1Object {
  private GSUCCESS() {}
  private static final KL1Object singleton = new GSUCCESS();
  public static final KL1Object getInstance() { return singleton; }
}


final class GFAILURE extends KL1Object {
  private GFAILURE() {}
  private static final KL1Object singleton = new GFAILURE();
  public static final KL1Object getInstance() { return singleton; }
}
