/*
 * GCObj.java -- generic consumer object
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: GCObj.java,v 1.3 1999-03-06 04:39:11+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class is an abstract class for generic consumer object.
 *
 * @author Satoshi KURAMOCHI
 */
public abstract class GCObj extends KL1Object {
  /** the name of the generic object */
  public static String name = "gcobj";


  public static KL1Object _new(KL1Machine mach, KL1Object argv[]) {
    return GDObj.FAILURE;
  }


  /**
   * Performs an active unification.
   *
   * @param   mach
   * @param   that  the object with which to unify.
   * @return  true if succeeds; false if fails.
   */
  public KL1Object active_unify(KL1Machine mach, KL1Object that) {
    return GDObj.FAILURE;
  }


  public KL1Object deref() {
    return this;
  }


//public int regist();
//public int deallocate();
//public KL1Object close();
//public KL1Object encode(int node);


  protected static Var suspend_new(KL1Machine mach, Var reason,
				   Class class_, KL1Object argv[]) {
    Var newvar = new Var();
    Var var = new Var(newvar);
    GObject newobj = new GObject(class_);
    GTermarray term = new GTermarray(argv);
    KL1Object args[] = { newvar, newobj, term };
    Predicate pred = mach.module_generic.predicate_new_3;
    Goalrec goal = new Goalrec(null, pred, args);
    mach.suspend_goal(goal, reason);
    return var;
  }


  // gc_macro.h
  protected static void error_in_new(KL1Machine mach, String errmsg) {
    mach.fatal(errmsg + "\n\t(in creation of consumer object of class \""
	       + name + "\")");
  }


  protected static void kl1_unify(KL1Machine mach, KL1Object x, KL1Object y) {
    KL1Object args[] = { x, y };
    Goalrec gp =
      new Goalrec(null, mach.module_uterms.predicate_unify__goal_2, args);
    mach.resume_same_prio(gp);
  }


  protected static void unify_value(KL1Machine mach,
				    KL1Object x, KL1Object y) {
    if (!(x instanceof Var) || ((Var)x).refers != x)
      y.shallow_unify(mach, x);
    else
      ((Var)x).refers = y;
  }


  /**
   * Creates a hook variable.
   *
   * @return  a variable to be created.
   */
  public Var make_hook_var() {
    return make_hook_var(this);
  }


  // generic.c
  protected static Var make_hook_var(GCObj obj) {
    Susprec susp = new Susprec();
    Var newvar = new Var(susp);
    susp.refers = newvar;
    susp.first_hook.next = susp.first_hook;
    susp.first_hook.u = obj;
    return newvar;
  }
}
