/*
 * Functor.java -- a functor structure
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Functor.java,v 1.2 1999-03-06 04:38:44+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a functor structure.
 *
 * @author Satoshi KURAMOCHI
 */
public class Functor extends KL1Object {
  /** a principal functor */
  public String functor;	// must be normalized
  /** arguments */
  public KL1Object args[];


  /**
   * Constructs a functor.
   *
   * @param  functor  a pricipal functor.
   * @param  args     arguments
   */
  public Functor(String functor, KL1Object args[]) {
    this.functor = functor;
    this.args = new KL1Object[args.length];
    for(int i = 0; i < args.length; i++)
      this.args[i] = args[i];
  }


  public KL1Object deref() {
    return this;
  }


  public KL1Object gunify(KL1Object that) {
    if((that = that.deref()) instanceof Functor) {
      if(functor != ((Functor)that).functor)
	return GDObj.FAILURE;
      for(int i = 0; i < args.length; i++) {
	KL1Object retval;
	if((retval = args[i].gunify(((Functor)that).args[i])) != GDObj.SUCCESS)
	  return retval;
      }
      return GDObj.SUCCESS;
    } else
      return (that instanceof Var) ? that : GDObj.FAILURE;
  }


  public void unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Functor.unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.resume_goals(temp, this);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (this != that)
      mach.enqueue_unify_terms(this, that);

/*
    if(!(that instanceof Functor))
      return that.unify(this);
    if(functor != ((Functor)that).functor)
      return false;
    if(args.length != ((Functor)that).args.length)
      return false;
    for(int i = 0; i < args.length; i++) {
      if(!(args[i].unify(((Functor)that).args[i])))
	return false;
    }
*/
  }


  public void shallow_unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Functor.unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.enqueue_unify_goal(this, that);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (this != that)
      mach.enqueue_unify_goal(this, that);

/*
    if(!(that instanceof Functor))
      return that.unify(this);
    if(functor != ((Functor)that).functor)
      return false;
    if(args.length != ((Functor)that).args.length)
      return false;
    for(int i = 0; i < args.length; i++) {
      if(!(args[i].unify(((Functor)that).args[i])))
	return false;
    }
*/
  }


  public String toString() {
    String s = functor + "(";
    int i;
    for(i = 0; i < args.length-1; i++) {
      s += args[i].toString();
      s += ",";
    }
    if(i < args.length)
      s += args[i].toString();
    return s + ")";
  }


  public String print() {
//  String s = functor + "(";
    String s = normalize() + "(";
    int i;
    for(i = 0; i < args.length-1; i++) {
      s += args[i].print();
      s += ",";
    }
    if(i < args.length)
      s += args[i].print();
    return s + ")";
  }


  public String normalize() {
    String s = "";
    int pos;
    if((pos = functor.lastIndexOf('_')) == -1) {
      System.err.println("Functor#normalize(): functor contains no '_'.");
      return null;
    }
    char[] buf = new char[pos];
    functor.getChars(0, pos, buf, 0);
    int i;
    for(i = 0; i < pos; i++) {
      if(buf[i] == '_') {
	if(buf[i+1] == '_') {	// '_' '_' -> '_'
	  s += '_';
	  i++;
	} else {		// '_' hex hex -> char
	  char x = buf[i+1];
	  x -= (char)((x > 'A') ? 'A'-10 : '0');
	  x *= 16;
	  x += buf[i+2];
	  x -= (char)((buf[i+2] > 'A') ? 'A'-10 : '0');
	  s += x;
	  i += 2;
	}
      } else
	s += buf[i];
    }
    return s;
  }
}
