/*
 * Cons.java -- a cons cell
 *
 * (C)1993, 1994, 1995 Institute for New Generation Computer Technology
 *	(Read COPYRIGHT for detailed information.) 
 *
 * (C)1996, 1997 Japan Information Processing Development Center
 *      (Read COPYRIGHT-JIPDEC for detailed information.)
 *
 * Copyright (C) 1998,1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: Cons.java,v 1.2 1999-03-06 04:37:33+09 satoshi Exp $
 */

package kl1.lang;

/**
 * This class represents a cons cell.
 *
 * @author Satoshi KURAMOCHI
 */
public class Cons extends KL1Object {
  /** The second element of the cons cell */
  public KL1Object cdr;
  /** The first element of the cons cell */
  public KL1Object car;


  /**
   * Constructs a cons cell.
   *
   * @param  cdr  the second element of the cons cell.
   * @param  car  the first element of the cons cell.
   */
  public Cons(KL1Object cdr, KL1Object car) {
    this.cdr = cdr;
    this.car = car;
  }


  public KL1Object deref() {
    return this;
  }


  public KL1Object gunify(KL1Object that) {
    if((that = that.deref()) instanceof Cons) {
      KL1Object retval = car.gunify(((Cons)that).car);
      if(retval == GDObj.SUCCESS)
	retval = cdr.gunify(((Cons)that).cdr);
      return retval;
    } else
      return (that instanceof Var) ? that : GDObj.FAILURE;
  }


  public void unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Cons.unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.resume_goals(temp, this);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (this != that)
      mach.enqueue_unify_terms(this, that);

/*  if(that instanceof Cons) {
      return car.unify(((Cons)that).car) && cdr.unify(((Cons)that).cdr);
    } else
      return that.unify(mach, this);*/
  }


  public void shallow_unify(KL1Machine mach, KL1Object that) {
    if(mach.UNIFYDEBUG)
      mach.print("Cons.unify with " + this.print() + "," + that.print());
    while (that instanceof Var) {
      KL1Object temp = ((Var)that).refers;
      if (temp == that) { // that is undef cell
	((Var)that).refers = this;
	return;
      } else {
	if(temp instanceof Var && ((Var)temp).refers == that) {
	  mach.enqueue_unify_goal(this, that);
	  return;
	}
      }
      that = temp;
    }
    // that is bound
    if (this != that)
      mach.enqueue_unify_goal(this, that);

/*  if(that instanceof Cons) {
      return car.unify(((Cons)that).car) && cdr.unify(((Cons)that).cdr);
    } else
      return that.unify(mach, this);*/
  }


  public String toString() {
    return "[" + car.toString() + "|" + cdr.toString() + "]";	// list ???
  }


  public String print() {
    return "[" + car.print() + "|" + cdr.print() + "]";	// ???
  }
}

