/*
 * vrbs2.java -- visualize rbs
 *
 * Copyright (C) 1996 Kenta Cho (cho@ueda.info.waseda.ac.jp)
 *
 * Copyright (C) 1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * $Id: vrbs2.java,v 1.2 1999-03-04 04:45:23+09 satoshi Exp satoshi $
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import kl1.lang.*;

public class vrbs2 extends Applet {
  private Thread KL1Thread = null;
  private KL1Machine mach = null;
  private WTC wtc = null;
  private Var tty = null;

  private static final String functor_element_2 = "element_2".intern();
  private static final String functor_fire_5 = "fire_5".intern();
  private static final String functor_rb_8 = "rb_8".intern();

  private boolean ok = false;

  private Screen scr;
  private Image offImage[];
  private Image image;
  private Graphics g;
  private int curImage = 0;

  private long currentTime = 0;
  private TextField fpsText;
  private Button startButton;
  private Button exitButton;

  private static final String TITLE = "krbs";
  private static final String FONTNAME =
    "-adobe-times-medium-r-normal--14-100-100-100-p-74-iso8859-1";
  private final int SCREENINTERVAL = 1;
  private final int SCREENSIZE = 512;

  private Color red, blue, green, back, white;

  private int xscsize,yscsize;
  private int xwinsize=-1,ywinsize;
  private int xwinoffset=-1,ywinoffset;

  private int screeninterval=SCREENINTERVAL;

  private static int dsin[] = new int[360];
  private static int dcos[] = new int[360];

  static {
    // initsc
    for(int i=0; i<360 ; i++ ) {
      dsin[i] = (int)(Math.sin((float)i*3.1415/180)*256);
      dcos[i] = (int)(Math.cos((float)i*3.1415/180)*256);
    }
  }

  private int gtime=0;

  private String rbname[] = new String[16];

  private static final String default_robots[] = {
    "testrobot1", "testrobot2", "testrobot4", "testrobot3", 
    "testrobot6", "testrobot5", "testrobot6", "testrobot5"
  };

  private int rbsh[] = new int[17];

  private static final int rf[][][] = new int[][][] {
    {{0,8}, {150,8}, {210,8}, {-32768,0}, {0,0},   {0,0},   {0,0},   {0,0}}, 
    {{0,6}, {90,8},  {140,6}, {180,2}, {220,6}, {270,8}, {-32768,0}, {0,0}}, 
    {{0,8}, {45,6},  {135,6}, {225,6}, {315,6}, {-32768,0}, {0,0},   {0,0}}, 
    {{0,2}, {20,8},  {130,7}, {230,7}, {340,8}, {-32768,0}, {0,0},   {0,0}}, 
    {{0,8}, {130,8}, {180,2}, {230,8}, {-32768,0}, {0,0},   {0,0},   {0,0}}, 
    {{0,7}, {80,6},  {120,7}, {180,6}, {240,7}, {280,6}, {-32768,0}, {0,0}}, 
    {{0,8}, {90,1},  {130,8}, {230,8}, {270,1}, {-32768,0}, {0,0},   {0,0}}, 
    {{0,8}, {100,2}, {70,6},  {150,7}, {210,7}, {290,6}, {260,2}, {-32768,0}}
  };


  public String getAppletInfo() {
    return 
    "krbs: KL1 Robot Battle Simulator\n" +
    "Copyright (C) 1996 Kenta Cho (cho@ueda.info.waseda.ac.jp)\n" +
    "Copyright (C) 1999 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>\n";
  }


  public String[][] getParameterInfo() {
    String[][] info = null;
    return info;
  }


  public void init() {
    System.err.println("[init]");
    int i;
    // initfirst
    // initall
    for(i=0; i<16 ; i++ )
      rbsh[i]=100;
    xscsize=768; yscsize=512;
    if ( xwinsize==-1 ) {
      xwinsize=ywinsize=SCREENSIZE;
    }
    xwinsize*=1.5;

    for(i = 0; i < 16; i++)
      rbname[i] = "";
    for(i = 0; i < default_robots.length; i++)
      rbname[i] = default_robots[i];

    // openwindow
//  red = Color.getColor("tomato");
    red = new Color(255, 99, 71);
//  blue = Color.getColor("dodger blue");
    blue = new Color(30, 144, 255);
//  green = Color.getColor("darkgreen");
    green = new Color(0, 100, 0);
    back = Color.black;
    white = Color.white;

    Panel p1 = new Panel();
    add(p1);
    p1.setLayout(new FlowLayout());

    scr = new Screen();
    scr.setSize(768, 512);
    p1.add(scr);

    offImage = new Image[2];

    Panel p2 = new Panel();
    p2.setLayout(new FlowLayout());
    add(p2);

    p2.add(new Label("frames per second:"));
    fpsText = new TextField(5);
    fpsText.setEditable(false);
    p2.add(fpsText);

    startButton = new Button("start");
    startButton.addActionListener(new StartActionListener());
    startButton.setEnabled(false);
    p2.add(startButton);

    exitButton = new Button("stop");
    exitButton.addActionListener(new ExitActionListener());
    exitButton.setEnabled(true);
    p2.add(exitButton);
  }


  private class Screen extends Canvas {
    public void paint(Graphics g) {
      ok = true;
      update(g);	// ???
    }


    public void update(Graphics g) {
      if(offImage[curImage] != null)
	scr.getGraphics().drawImage(offImage[curImage], 0, 0, this);
    }
  }


  private final class ExitActionListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      if(mach != null && wtc != null)
	mach.return_wtc(wtc);
//    Thread.yield();
      stop();
//    System.exit(0);
    }
  }


  private final class StartActionListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      start();
    }
  }


  /* 
   * draw line
   */
  private final void drawline(int x1,int y1,int x2,int y2) {
    int sx1,sy1,sx2,sy2;
    sx1=x1*xwinsize/xscsize;
    sx2=x2*xwinsize/xscsize;
    sy1=y1*ywinsize/yscsize;
    sy2=y2*ywinsize/yscsize;
    g.drawLine(sx1,sy1,sx2,sy2);
  }


  /* 
   * draw circle
   */
  private final void drawcircle(int x,int y,int xw,int yw) {
    int sx,sy,swx,swy;
    sx=x*xwinsize/xscsize;
    swx=xw*xwinsize/xscsize;
    sy=y*ywinsize/yscsize;
    swy=yw*ywinsize/yscsize;
    g.drawArc(sx-swx,sy-swy,swx*2,swy*2,0,23040);
  }


  /* 
   * draw string
   */
  private final void drawstring(int x,int y,String str) {
    int sx,sy;
    sx=x*xwinsize/xscsize;
    sy=y*ywinsize/yscsize;
    g.drawString(str, sx,sy);
  }


  private final void putwinner() {
    int i=0,ws=-1;
    while ( rbsh[i]!=-32768 ) {
      if ( rbsh[i]>0 ) {
	ws = i & 1;
	break;
      }
      i++;
    }
    g.setColor(white);
    switch (ws) {
    case 0:
      drawstring(256,256,"Blue Side Won.");
      break;
    case 1:
      drawstring(256,256,"Red Side Won.");
      break;
    case -1:
      drawstring(256,256,"Draw Game.");
      break;
    }
  }


  private final void putback() {
    int i;
    g.setColor(green);
    drawline(128,0,128,512);
    for ( i=31 ; i<512 ; i+=32 )
      drawline(i+128,0,i+128,512);
    drawline(128,0,640,0);
    for ( i=31 ; i<512 ; i+=32 )
      drawline(128,i,640,i);
  }


  private final void putstatus(int stx, int sty, int mx, int my, int d, int bt,
			       int dt, int shield, int shote, String command,
			       int n, int color) {
    int i,x,y;
    int strtx,strty,x1,y1,x2,y2,nd,sp;

    x=stx; y=sty;
    g.setColor(green);
    x=stx;
    if ( stx==0 ) x+=128;
    drawline(stx,sty+63,stx+128,sty+63);
    drawline(stx,sty+16,stx+64,sty+16);
    command = command.substring(0, Math.min(14, command.length()));
    drawstring(stx,sty+36,new String(command));
    switch (color) {
    case 0:
      g.setColor(white);
      break;
    case 1:
      g.setColor(blue);
      break;
    case 2:
      g.setColor(red);
      break;
    }
    drawstring(stx,sty+16,rbname[n]);
    x=stx+64;
    y=sty+32;
    i=0;
    sp=(n>>1);
    strtx=x1=x+((dsin[d]*rf[sp][i][1])>>8);
    strty=y1=y-((dcos[d]*rf[sp][i][1])>>8);
    i++;
    while ( rf[sp][i][0] !=-32768 ) {
      nd=d+rf[sp][i][0];
      while ( nd>=360 )
	nd-=360;
      x2=x+((dsin[nd]*rf[sp][i][1])>>8);
      y2=y-((dcos[nd]*rf[sp][i][1])>>8);
      drawline(x1,y1,x2,y2);
      x1=x2; y1=y2;
      i++;
    }
    drawline(x1,y1,strtx,strty);
    if ( bt>0 )
      drawcircle(x,y,3+bt*2,7+bt);
    x=stx; y=sty+52;
    for ( i=0 ; i<shield/5 ; i++ ) {
      drawline(x,y,x,y+11);
      x+=5;
    }
    y=sty+48;
    String shield_str = Integer.toString(shield);
    drawstring(stx+100,y+16, shield_str);
    drawstring(mx,my-16, shield_str);
    x=stx; y=sty+48;
    if ( dt>0 )
      drawstring(x,y,"Dash");
    x=stx+96;
    for ( i=0 ; i<shote/10 ; i++ ) {
      drawstring(x,y,"S");
      x+=8;
    }
  }


  private final void putrobot(KL1Object rb) {
    int x = 0, y = 0, d = 0, dt = 0, bt = 0, se = 0, shield = 0;
    String co = null;
    int n=0,i;
    int sx,sy;
    int strtx,strty,x1,y1,x2,y2,nd,sp;
    int stx=0,sty=0;
    int col;

    rb = rb.deref();
    if(!(rb instanceof GVector))
      fatal();
    for(int j = 0; j < 8; j++) {
      KL1Object argv[] = new KL1Object[2];
      argv[0] = new IntAtom(j);
      ((GVector)rb).ggeneric(functor_element_2, argv);
      KL1Object rb1 = argv[1].deref();
      Functor rb2 = null;
      if(!(rb1 instanceof Functor &&
	   (rb2 = (Functor)rb1).functor == functor_rb_8))
	fatal();
      try {
	x = ((IntAtom)rb2.args[0].deref()).value;
	y = ((IntAtom)rb2.args[1].deref()).value;
	KL1Object td = rb2.args[2].deref();
	if(td instanceof SymAtom)
	  d = -1;
	else
	  d = ((IntAtom)td).value;
	dt = ((IntAtom)rb2.args[3].deref()).value;
	bt = ((IntAtom)rb2.args[4].deref()).value;
	se = ((IntAtom)rb2.args[5].deref()).value;
	shield = ((IntAtom)rb2.args[6].deref()).value;
	co = rb2.args[7].deref().toString();
//	co = rb2.args[7].deref().print();
      } catch(ClassCastException e) {
	System.err.println(e.toString());
	fatal();
      }

      if ( shield>0 ) {
	if ( rbsh[n]-shield>=5 ) {
	  g.setColor(white);
	  col=0;
	} else if ( (n&1)==0 ) {
	  g.setColor(blue);
	  col=1;
	} else {
	  g.setColor(red);
	  col=2;
	}
	rbsh[n]=shield;
	sx=x/(25600/512)+128;
	sy=y/(25600/512);
	
	if ( d==-1 )
	  d=0;
	i=0;
	sp=(n>>1);
	strtx=x1=sx+((dsin[d]*rf[sp][i][1])>>8);
	strty=y1=sy-((dcos[d]*rf[sp][i][1])>>8);
	i++;
	while ( rf[sp][i][0] !=-32768 ) {
	  nd=d+rf[sp][i][0];
	  while ( nd>=360 ) nd-=360;
	  x2=sx+((dsin[nd]*rf[sp][i][1])>>8);
	  y2=sy-((dcos[nd]*rf[sp][i][1])>>8);
	  drawline(x1,y1,x2,y2);
	  x1=x2; y1=y2;
	  i++;
	}
	drawline(x1,y1,strtx,strty);
	if ( bt>0 )
	  drawcircle(sx,sy,3+bt*2,7+bt);
	putstatus(stx,sty,sx,sy,d,bt,dt,shield,se,co,n,col);
      }
      else rbsh[n]=0;
      if ( stx==0 )
	stx=640;
      else { stx=0; sty+=64; }
      n++;
    }
    rbsh[n]=-32768;
  }

  
  private final void putshot(KL1Object sh) {
    sh = sh.deref();
    while(sh != SymAtom.nil) {
      int n = 0, an = 0, x = 0, y = 0, d = 0;
      try {
	Functor sh1 = (Functor)((Cons)sh).car.deref();
	sh = ((Cons)sh).cdr.deref();
	if(sh1.functor != functor_fire_5)
	  fatal();
	n = ((IntAtom)sh1.args[0].deref()).value;
	an = ((IntAtom)sh1.args[1].deref()).value;
	x = ((IntAtom)sh1.args[2].deref()).value;
	y = ((IntAtom)sh1.args[3].deref()).value;
	d = ((IntAtom)sh1.args[4].deref()).value;
      } catch(ClassCastException e) {
	fatal();
      }

      if((n & 1) == 0)
	g.setColor(blue);
      else
	g.setColor(red);
      int sx=x/(25600/512)+128;
      int sy=y/(25600/512);
      int d1=d+170; if ( d1>=360 ) d1-=360;
      int d2=d1+20; if ( d2>=360 ) d2-=360;
      drawline(sx+(dsin[d]>>6),sy-(dcos[d]>>6),
	       sx+(dsin[d1]>>6),sy-(dcos[d1]>>6));
      drawline(sx+(dsin[d1]>>6),sy-(dcos[d1]>>6),
	       sx+(dsin[d2]>>6),sy-(dcos[d2]>>6));
      drawline(sx+(dsin[d2]>>6),sy-(dcos[d2]>>6),
	       sx+(dsin[d]>>6),sy-(dcos[d]>>6));
    }
  }

  
  public void start() {
    System.err.println("[start]");
    if(KL1Thread == null || !KL1Thread.isAlive()) {
      System.gc();
      System.runFinalization();

      // create KL1 thread
      GNotifier obj = new MyNotifier();
      tty = obj.make_hook_var();
      mach = new KL1Machine("jmain", "main", 1, new KL1Object[]{ tty });
      wtc = mach.get_wtc();
      KL1Thread = new Thread(mach);
      KL1Thread.setPriority(Thread.NORM_PRIORITY-1);
      KL1Thread.start();
      startButton.setEnabled(false);
      exitButton.setEnabled(true);
    }
  }


  private final class MyNotifier extends GNotifier {
    public void _notify(KL1Object var) {
//    System.err.println("*notified");
      while(!ok) {
	try {
	  Thread.sleep(100);
	} catch(Exception e) {}
      }
      if(currentTime == 0)
	currentTime = System.currentTimeMillis();

      if((var = var.deref()) instanceof Cons) {
	KL1Object rb = ((Cons)var).car;
	KL1Object cdr = ((Cons)var).cdr.deref();
	if(!(cdr instanceof Cons)) {
	  System.err.println(cdr.print());
	  fatal();
	}
	KL1Object sh = ((Cons)cdr).car;

	if(offImage[curImage] == null) {
//	  System.err.println("created(" + curImage + ")");
	  offImage[curImage] = createImage(768, 512);
	}
	image = offImage[curImage];
	image.flush();
	g = image.getGraphics();
	g.setColor(Color.black);
	g.fillRect(0,0,xwinsize,ywinsize);

	putback();
	putrobot(rb);
	putshot(sh);
	scr.getGraphics().drawImage(image, 0, 0, scr);
	curImage = 1-curImage;

	long currentTime1 = System.currentTimeMillis();
	double fps = 1000.0/(currentTime1 - currentTime);
	String str = Double.toString(fps);
	str = str.substring(0, Math.min(5, str.length()));
	fpsText.setText(str);
	currentTime = currentTime1;

//	time1=0;
//	gtime++;

	GNotifier obj = new MyNotifier();
	tty = obj.make_hook_var();
	mach.send_unify(wtc, ((Cons)cdr).cdr, tty);
	Thread.yield();
      } else if(var == SymAtom.nil) {
	curImage = 1-curImage;
	putwinner();
	scr.getGraphics().drawImage(image, 0, 0, scr);
	mach.return_wtc(wtc);

	KL1Thread = null;
	mach = null;
	startButton.setEnabled(true);
	exitButton.setEnabled(false);
	return;
      } else {
	System.err.println(var.print());
	fatal();
      }
//    System.err.println("*notified.exit");
    }
  }


  private final void fatal() {
    System.err.println("Invalid data");
    new Exception("Stack trace").printStackTrace();	// debug
    stop();
//    System.exit(1);
  }


  public void stop() {
    System.err.println("[stop]");
    if(KL1Thread != null && KL1Thread.isAlive())
      KL1Thread.stop();
    KL1Thread = null;
    mach = null;
    wtc = null;
    tty = null;
    startButton.setEnabled(true);
    exitButton.setEnabled(false);
  }


  public void destroy() {
    System.err.println("[destroy]");
    Thread.currentThread().stop();
//    System.exit(0);
  }


  public static void main(String args[]) {
    WindowListener l = new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
//	System.exit(0);
	Thread.currentThread().stop();
      }
    };

    Frame f = new Frame(TITLE);
    f.addWindowListener(l); 

    Applet a = new vrbs2();
    a.init();
    a.start();
    f.add(a);
    f.setSize(768+32, 512+96);
    f.show();
  }
}
